import { useMemo } from 'react';
import defaults from 'lodash/defaults';
import { useResourceDefinitions } from './useResourceDefinitions';
import { useResourceContext } from './useResourceContext';
/**
 * Hook to get the definition of a given resource
 *
 * @example // Get the current resource definition (based on ResourceContext)
 *
 * const definition = useResourceDefinition();
 * console.log(definition);
 * // {
 * //   name: 'posts',
 * //   hasList: true,
 * //   hasEdit: true,
 * //   hasShow: true,
 * //   hasCreate: true,
 * //   options: {},
 * //   icon: PostIcon,
 * // }
 *
 * @example // Pass a resource prop to check a different resource definition
 *
 * const definition = useResourceDefinition({ resource: 'posts' });
 */
export var useResourceDefinition = function (props) {
    var resource = useResourceContext(props);
    var resourceDefinitions = useResourceDefinitions();
    var _a = props || {}, hasCreate = _a.hasCreate, hasEdit = _a.hasEdit, hasList = _a.hasList, hasShow = _a.hasShow, recordRepresentation = _a.recordRepresentation;
    var definition = useMemo(function () {
        return defaults({}, {
            hasCreate: hasCreate,
            hasEdit: hasEdit,
            hasList: hasList,
            hasShow: hasShow,
            recordRepresentation: recordRepresentation,
        }, resource ? resourceDefinitions[resource] : {});
    }, [
        resource,
        resourceDefinitions,
        hasCreate,
        hasEdit,
        hasList,
        hasShow,
        recordRepresentation,
    ]);
    return definition;
};
//# sourceMappingURL=useResourceDefinition.js.map