import { DataProvider } from '../types';
export type DataProviderMatcher = (resource: string) => DataProvider;
/**
 * Combine multiple data providers into one.
 *
 * @param dataProviderMatcher A function that returns a data provider for a given resource.
 *
 * @example
 * const dataProvider = combineDataProviders(resource => {
 *    switch(resource) {
 *       case 'posts':
 *       case 'comments':
 *          return dataProvider1;
 *       case 'users':
 *          return dataProvider2;
 *       default:
 *         throw new Error('Unknown resource');
 *    }
 * });
 */
export declare const combineDataProviders: (dataProviderMatcher: DataProviderMatcher) => DataProvider;
//# sourceMappingURL=combineDataProviders.d.ts.map