var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { defaultDataProvider } from './defaultDataProvider';
/**
 * Combine multiple data providers into one.
 *
 * @param dataProviderMatcher A function that returns a data provider for a given resource.
 *
 * @example
 * const dataProvider = combineDataProviders(resource => {
 *    switch(resource) {
 *       case 'posts':
 *       case 'comments':
 *          return dataProvider1;
 *       case 'users':
 *          return dataProvider2;
 *       default:
 *         throw new Error('Unknown resource');
 *    }
 * });
 */
export var combineDataProviders = function (dataProviderMatcher) {
    return new Proxy(defaultDataProvider, {
        get: function (target, name) {
            if (name === 'then') {
                return null;
            }
            return function (resource) {
                var _a;
                var params = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    params[_i - 1] = arguments[_i];
                }
                if (typeof name === 'symbol') {
                    return;
                }
                return (_a = dataProviderMatcher(resource))[name].apply(_a, __spreadArray([resource], params, false));
            };
        },
    });
};
//# sourceMappingURL=combineDataProviders.js.map