import { LegacyDataProvider, DataProvider } from '../types';
/**
 * Turn a function-based dataProvider to an object-based one
 *
 * Allows using legacy dataProviders transparently.
 *
 * @param {Function} legacyDataProvider A legacy dataProvider (type, resource, params) => Promise<any>
 *
 * @returns {Object} A dataProvider that react-admin can use
 */
declare const convertLegacyDataProvider: (legacyDataProvider: LegacyDataProvider) => DataProvider;
export default convertLegacyDataProvider;
//# sourceMappingURL=convertLegacyDataProvider.d.ts.map