var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { useQuery, } from '@tanstack/react-query';
import { useDataProvider } from './useDataProvider';
import { useEffect } from 'react';
import { useEvent } from '../util';
/**
 * Call the dataProvider.getOne() method and return the resolved value
 * as well as the loading state.
 *
 * The return value updates according to the request state:
 *
 * - start: { isPending: true, isFetching: true, refetch }
 * - success: { data: [data from response], isPending: false, refetch }
 * - error: { error: [error from response], isPending: false, refetch }
 *
 * This hook will return the cached result when called a second time
 * with the same parameters, until the response arrives.
 *
 * @param resource The resource name, e.g. 'posts'
 * @param {Params} params The getOne parameters { id, meta }, e.g. { id: 123 }
 * @param {Options} options Options object to pass to the react-query queryClient.
 *
 * @typedef Params
 * @prop id a resource identifier, e.g. 123
 *
 * @typedef Options
 * @prop enabled Flag to conditionally run the query. If it's false, the query will not run
 * @prop onSuccess Side effect function to be executed upon success, e.g. { onSuccess: { refresh: true } }
 * @prop onError Side effect function to be executed upon failure, e.g. { onError: error => notify(error.message) }
 *
 * @returns The current request state. Destructure as { data, error, isPending, refetch }.
 *
 * @example
 *
 * import { useGetOne, useRecordContext } from 'react-admin';
 *
 * const UserProfile = () => {
 *     const record = useRecordContext();
 *     const { data, isPending, error } = useGetOne('users', { id: record.id });
 *     if (isPending) { return <Loading />; }
 *     if (error) { return <p>ERROR</p>; }
 *     return <div>User {data.username}</div>;
 * };
 */
export var useGetOne = function (resource, _a, options) {
    var id = _a.id, meta = _a.meta;
    if (options === void 0) { options = {}; }
    var dataProvider = useDataProvider();
    var _b = options.onError, onError = _b === void 0 ? noop : _b, _c = options.onSuccess, onSuccess = _c === void 0 ? noop : _c, _d = options.onSettled, onSettled = _d === void 0 ? noop : _d, enabled = options.enabled, queryOptions = __rest(options, ["onError", "onSuccess", "onSettled", "enabled"]);
    var onSuccessEvent = useEvent(onSuccess);
    var onErrorEvent = useEvent(onError);
    var onSettledEvent = useEvent(onSettled);
    var result = useQuery(__assign({ 
        // Sometimes the id comes as a string (e.g. when read from the URL in a Show view).
        // Sometimes the id comes as a number (e.g. when read from a Record in useGetList response).
        // As the react-query cache is type-sensitive, we always stringify the identifier to get a match
        queryKey: [resource, 'getOne', { id: String(id), meta: meta }], queryFn: function (queryParams) {
            return id == null
                ? new Promise(function () { })
                : dataProvider
                    .getOne(resource, {
                    id: id,
                    meta: meta,
                    signal: dataProvider.supportAbortSignal === true
                        ? queryParams.signal
                        : undefined,
                })
                    .then(function (_a) {
                    var data = _a.data;
                    return data;
                });
        }, enabled: enabled !== null && enabled !== void 0 ? enabled : id != null }, queryOptions));
    useEffect(function () {
        if (result.data === undefined ||
            result.error != null ||
            result.isFetching)
            return;
        onSuccessEvent(result.data);
    }, [onSuccessEvent, result.data, result.error, result.isFetching]);
    useEffect(function () {
        if (result.error == null || result.isFetching)
            return;
        onErrorEvent(result.error);
    }, [onErrorEvent, result.error, result.isFetching]);
    useEffect(function () {
        if (result.status === 'pending' || result.isFetching)
            return;
        onSettledEvent(result.data, result.error);
    }, [
        onSettledEvent,
        result.data,
        result.error,
        result.status,
        result.isFetching,
    ]);
    return result;
};
var noop = function () { return undefined; };
//# sourceMappingURL=useGetOne.js.map