var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { useInfiniteQuery, useQueryClient, } from '@tanstack/react-query';
import { useDataProvider } from './useDataProvider';
import { useEffect, useRef } from 'react';
import { useEvent } from '../util';
var MAX_DATA_LENGTH_TO_CACHE = 100;
/**
 * Call the dataProvider.getList() method and return the resolved result
 * as well as the loading state. The return from useInfiniteGetList is equivalent to the return from react-hook form useInfiniteQuery.
 *
 * @see https://tanstack.com/query/v5/docs/react/reference/useInfiniteQuery
 *
 * This hook will return the cached result when called a second time
 * with the same parameters, until the response arrives.
 *
 * @param {string} resource The resource name, e.g. 'posts'
 * @param {Params} params The getList parameters { pagination, sort, filter, meta }
 * @param {Object} options Options object to pass to the queryClient.
 * May include side effects to be executed upon success or failure, e.g. { onSuccess: () => { fetchNextPage(); } }
 *
 * @typedef Params
 * @prop params.pagination The request pagination { page, perPage }, e.g. { page: 1, perPage: 10 }
 * @prop params.sort The request sort { field, order }, e.g. { field: 'id', order: 'DESC' }
 * @prop params.filter The request filters, e.g. { title: 'hello, world' }
 * @prop params.meta Optional meta parameters
 *
 * @returns The current request state. Destructure as { data, total, error, isPending, isSuccess, hasNextPage, fetchNextPage }.
 *
 * @example
 *
 * import { useInfiniteGetList } from 'react-admin';
 *
 * const LatestNews = () => {
 *     const { data, total, isPending, error, hasNextPage, fetchNextPage } = useInfiniteGetList(
 *         'posts',
 *         { pagination: { page: 1, perPage: 10 }, sort: { field: 'published_at', order: 'DESC' } }
 *     );
 *     if (isPending) { return <Loading />; }
 *     if (error) { return <p>ERROR</p>; }
 *     return (
 *        <>
 *            <ul>
 *                {data?.pages.map(page => {
 *                    return page.data.map(post => (
 *                        <li key={post.id}>{post.title}</li>
 *                    ));
 *                })}
 *            </ul>
 *            <div>
 *                <button disabled={!hasNextPage} onClick={() => fetchNextPage()}>
 *                    Fetch next page
 *                </button>
 *            </div>
 *        </>
 *    );
 * };
 */
export var useInfiniteGetList = function (resource, params, options) {
    var _a, _b, _c, _d, _e;
    if (params === void 0) { params = {}; }
    if (options === void 0) { options = {}; }
    var _f = params.pagination, pagination = _f === void 0 ? { page: 1, perPage: 25 } : _f, _g = params.sort, sort = _g === void 0 ? { field: 'id', order: 'DESC' } : _g, _h = params.filter, filter = _h === void 0 ? {} : _h, meta = params.meta;
    var dataProvider = useDataProvider();
    var queryClient = useQueryClient();
    var _j = options.onSuccess, onSuccess = _j === void 0 ? noop : _j, _k = options.onError, onError = _k === void 0 ? noop : _k, _l = options.onSettled, onSettled = _l === void 0 ? noop : _l, queryOptions = __rest(options, ["onSuccess", "onError", "onSettled"]);
    var onSuccessEvent = useEvent(onSuccess);
    var onErrorEvent = useEvent(onError);
    var onSettledEvent = useEvent(onSettled);
    var result = useInfiniteQuery(__assign(__assign({ queryKey: [
            resource,
            'getInfiniteList',
            { pagination: pagination, sort: sort, filter: filter, meta: meta },
        ], queryFn: function (queryParams) {
            var _a = queryParams.pageParam, pageParam = _a === void 0 ? pagination.page : _a;
            return dataProvider
                .getList(resource, {
                pagination: {
                    page: pageParam,
                    perPage: pagination.perPage,
                },
                sort: sort,
                filter: filter,
                meta: meta,
                signal: dataProvider.supportAbortSignal === true
                    ? queryParams.signal
                    : undefined,
            })
                .then(function (_a) {
                var data = _a.data, pageInfo = _a.pageInfo, total = _a.total, meta = _a.meta;
                return ({
                    data: data,
                    total: total,
                    pageParam: pageParam,
                    pageInfo: pageInfo,
                    meta: meta,
                });
            });
        }, initialPageParam: pagination.page }, queryOptions), { getNextPageParam: function (lastLoadedPage) {
            if (lastLoadedPage.pageInfo) {
                return lastLoadedPage.pageInfo.hasNextPage
                    ? lastLoadedPage.pageParam + 1
                    : undefined;
            }
            var totalPages = Math.ceil((lastLoadedPage.total || 0) / pagination.perPage);
            return lastLoadedPage.pageParam < totalPages
                ? Number(lastLoadedPage.pageParam) + 1
                : undefined;
        }, getPreviousPageParam: function (lastLoadedPage) {
            if (lastLoadedPage.pageInfo) {
                return lastLoadedPage.pageInfo.hasPreviousPage
                    ? lastLoadedPage.pageParam - 1
                    : undefined;
            }
            return lastLoadedPage.pageParam === 1
                ? undefined
                : lastLoadedPage.pageParam - 1;
        } }));
    var metaValue = useRef(meta);
    var resourceValue = useRef(resource);
    useEffect(function () {
        metaValue.current = meta;
    }, [meta]);
    useEffect(function () {
        resourceValue.current = resource;
    }, [resource]);
    useEffect(function () {
        if (result.data === undefined ||
            result.error != null ||
            result.isFetching)
            return;
        // optimistically populate the getOne cache
        var allPagesDataLength = result.data.pages.reduce(function (acc, page) { return acc + page.data.length; }, 0);
        if (allPagesDataLength <= MAX_DATA_LENGTH_TO_CACHE) {
            result.data.pages.forEach(function (page) {
                page.data.forEach(function (record) {
                    queryClient.setQueryData([
                        resourceValue.current,
                        'getOne',
                        { id: String(record.id), meta: metaValue.current },
                    ], function (oldRecord) { return oldRecord !== null && oldRecord !== void 0 ? oldRecord : record; });
                });
            });
        }
        onSuccessEvent(result.data);
    }, [
        onSuccessEvent,
        queryClient,
        result.data,
        result.error,
        result.isFetching,
    ]);
    useEffect(function () {
        if (result.error == null || result.isFetching)
            return;
        onErrorEvent(result.error);
    }, [onErrorEvent, result.error, result.isFetching]);
    useEffect(function () {
        if (result.status === 'pending' || result.isFetching)
            return;
        onSettledEvent(result.data, result.error);
    }, [
        onSettledEvent,
        result.data,
        result.error,
        result.status,
        result.isFetching,
    ]);
    return (result.data
        ? __assign(__assign({}, result), { data: result.data, total: (_c = (_b = (_a = result.data) === null || _a === void 0 ? void 0 : _a.pages[0]) === null || _b === void 0 ? void 0 : _b.total) !== null && _c !== void 0 ? _c : undefined, meta: (_e = (_d = result.data) === null || _d === void 0 ? void 0 : _d.pages[0]) === null || _e === void 0 ? void 0 : _e.meta }) : result);
};
var noop = function () { return undefined; };
//# sourceMappingURL=useInfiniteGetList.js.map