import { getRelatedIds } from './getRelatedIds';
/**
 * Helper function for calling the dataProvider.getMany() method,
 * and getting a Promise for the records indexed by id in return.
 *
 * @example
 *     fetchRelatedRecords(dataProvider)(records, 'post_id', 'posts').then(posts =>
 *         posts.map(record => ({
 *             ...record,
 *             post_title: posts[record.post_id].title,
 *         }))
 *     );
 */
export var fetchRelatedRecords = function (dataProvider) {
    return function (data, field, resource) {
        return dataProvider
            .getMany(resource, { ids: getRelatedIds(data, field) })
            .then(function (_a) {
            var data = _a.data;
            return data.reduce(function (acc, post) {
                acc[post.id] = post;
                return acc;
            }, {});
        });
    };
};
//# sourceMappingURL=fetchRelatedRecords.js.map