var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import { useContext } from 'react';
import { FormProvider, } from 'react-hook-form';
import { UNSAFE_DataRouterContext, UNSAFE_DataRouterStateContext, } from 'react-router';
import { FormGroupsProvider } from './FormGroupsProvider';
import { useRecordContext, OptionalRecordContextProvider, } from '../controller';
import { SourceContextProvider, useResourceContext, } from '../core';
import { WarnWhenUnsavedChanges } from './WarnWhenUnsavedChanges';
import { useAugmentedForm } from './useAugmentedForm';
/**
 * Creates a form element, initialized with the current record, calling the saveContext on submit
 *
 * Wrapper around react-hook-form's useForm, FormContextProvider, and <form>.
 * Also sets up a FormGroupContext, and handles submission validation.
 *
 * @example
 *
 * const MyForm = ({ record, defaultValues, validate }) => (
 *    <Form record={record} defaultValues={defaultValues} validate={validate}>
 *        <Stack>
 *            <TextInput source="title" />
 *            <SaveButton />
 *        </Stack>
 *    </Form>
 * );
 *
 * @typedef {Object} Props the props you can use
 * @prop {Object} defaultValues
 * @prop {Function} validate
 * @prop {Function} save
 *
 * @see useForm
 * @see FormGroupContext
 *
 * @link https://react-hook-form.com/docs/useformcontext
 */
export function Form(props) {
    var children = props.children, id = props.id, className = props.className, _a = props.noValidate, noValidate = _a === void 0 ? false : _a, formRootPathname = props.formRootPathname, warnWhenUnsavedChanges = props.warnWhenUnsavedChanges, _b = props.WarnWhenUnsavedChangesComponent, WarnWhenUnsavedChangesComponent = _b === void 0 ? WarnWhenUnsavedChanges : _b;
    var record = useRecordContext(props);
    var resource = useResourceContext(props);
    var _c = useAugmentedForm(props), form = _c.form, formHandleSubmit = _c.formHandleSubmit;
    var sourceContext = React.useMemo(function () { return ({
        getSource: function (source) { return source; },
        getLabel: function (source) {
            return "resources.".concat(resource, ".fields.").concat(source);
        },
    }); }, [resource]);
    var dataRouterContext = useContext(UNSAFE_DataRouterContext);
    var dataRouterStateContext = useContext(UNSAFE_DataRouterStateContext);
    if (warnWhenUnsavedChanges &&
        (!dataRouterContext || !dataRouterStateContext) &&
        process.env.NODE_ENV === 'development') {
        console.error('Cannot use the warnWhenUnsavedChanges feature outside of a DataRouter. ' +
            'The warnWhenUnsavedChanges feature is disabled. ' +
            'Remove the warnWhenUnsavedChanges prop or convert your custom router to a Data Router.');
    }
    return (React.createElement(OptionalRecordContextProvider, { value: record },
        React.createElement(SourceContextProvider, { value: sourceContext },
            React.createElement(FormProvider, __assign({}, form),
                React.createElement(FormGroupsProvider, null,
                    React.createElement("form", { onSubmit: formHandleSubmit, noValidate: noValidate, id: id, className: className }, children),
                    warnWhenUnsavedChanges &&
                        dataRouterContext &&
                        dataRouterStateContext && (React.createElement(WarnWhenUnsavedChangesComponent, { enable: true, formRootPathName: formRootPathname, formControl: form.control })))))));
}
//# sourceMappingURL=Form.js.map