var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import { useTranslate } from '../i18n';
var ValidationErrorSpecialFormatPrefix = '@@react-admin@@';
var ValidationError = function (props) {
    var error = props.error;
    var errorMessage = error;
    var translate = useTranslate();
    // react-hook-form expects errors to be plain strings but our validators can return objects
    // that have message and args.
    // To avoid double translation for users that validate with a schema instead of our validators
    // we use a special format for our validators errors.
    // The useInput hook handle the special formatting
    if (typeof error === 'string' &&
        error.startsWith(ValidationErrorSpecialFormatPrefix)) {
        errorMessage = JSON.parse(error.substring(ValidationErrorSpecialFormatPrefix.length));
    }
    if (errorMessage.message) {
        var _a = errorMessage, message = _a.message, args = _a.args;
        return React.createElement(React.Fragment, null, translate(message, __assign({ _: message }, args)));
    }
    return React.createElement(React.Fragment, null, translate(errorMessage, { _: errorMessage }));
};
export default ValidationError;
//# sourceMappingURL=ValidationError.js.map