import { useEffect, useRef } from 'react';
import { useFormState } from 'react-hook-form';
import { useNotify } from '../notification';
/**
 * This hook display an error message on submit in Form and SaveButton.
 *
 * We can't do the form validity check in the form submit handler
 * as the form state may not have been updated yet when onSubmit validation mode is enabled
 * or when the form hasn't been touched at all.
 */
export var useNotifyIsFormInvalid = function (control, enabled) {
    if (enabled === void 0) { enabled = true; }
    var _a = useFormState(control ? { control: control } : undefined), submitCount = _a.submitCount, errors = _a.errors;
    var submitCountRef = useRef(submitCount);
    var notify = useNotify();
    useEffect(function () {
        var _a, _b;
        // Checking the submit count allows us to only display the notification after users
        // tried to submit
        if (submitCount > submitCountRef.current && enabled) {
            submitCountRef.current = submitCount;
            if (Object.keys(errors).length > 0) {
                var serverError = typeof ((_b = (_a = errors.root) === null || _a === void 0 ? void 0 : _a.serverError) === null || _b === void 0 ? void 0 : _b.message) === 'string'
                    ? errors.root.serverError.message
                    : undefined;
                notify(serverError || 'ra.message.invalid_form', {
                    type: 'error',
                });
            }
        }
    }, [errors, submitCount, notify, enabled]);
};
//# sourceMappingURL=useNotifyIsFormInvalid.js.map