import { ReactElement } from 'react';
import { UseChoicesOptions } from './useChoices';
export declare const useSuggestions: ({ allowCreate, choices, createText, createValue, limitChoicesToValue, matchSuggestion, optionText, optionValue, selectedItem, suggestionLimit, translateChoice, }: UseSuggestionsOptions) => {
    getChoiceText: (choice: any) => string | import("react").JSX.Element;
    getChoiceValue: (choice: any) => any;
    getSuggestions: (filter: any) => any[];
};
export interface UseSuggestionsOptions extends UseChoicesOptions {
    allowCreate?: boolean;
    allowDuplicates?: boolean;
    choices?: any[];
    createText?: string;
    createValue?: any;
    limitChoicesToValue?: boolean;
    matchSuggestion?: (filter: string, suggestion: any, exact?: boolean) => boolean;
    suggestionLimit?: number;
    selectedItem?: any | any[];
}
/**
 * Get the suggestions to display after applying a fuzzy search on the available choices
 *
 * @example
 *
 * getSuggestions({
 *   choices: [{ id: 1, name: 'admin' }, { id: 2, name: 'publisher' }],
 *   optionText: 'name',
 *   optionValue: 'id',
 *   getSuggestionText: choice => choice[optionText],
 * })('pub')
 *
 * // Will return [{ id: 2, name: 'publisher' }]
 * getSuggestions({
 *   choices: [{ id: 1, name: 'admin' }, { id: 2, name: 'publisher' }],
 *   optionText: 'name',
 *   optionValue: 'id',
 *   getSuggestionText: choice => choice[optionText],
 * })('pub')
 *
 * // Will return [{ id: 2, name: 'publisher' }]
 */
export declare const getSuggestionsFactory: ({ allowCreate, choices, createText, createValue, optionText, optionValue, getChoiceText, getChoiceValue, limitChoicesToValue, matchSuggestion, selectedItem, suggestionLimit, }: UseSuggestionsOptions & {
    getChoiceText: (choice: any) => string | ReactElement;
    getChoiceValue: (choice: any) => string;
}) => (filter: any) => any[];
//# sourceMappingURL=useSuggestions.d.ts.map