import * as React from 'react';
import lodashGet from 'lodash/get';
import { I18nContextProvider } from './I18nContextProvider';
export var TestTranslationProvider = function (_a) {
    var translate = _a.translate, messages = _a.messages, children = _a.children;
    return (React.createElement(I18nContextProvider, { value: testI18nProvider({ translate: translate, messages: messages }) }, children));
};
export var testI18nProvider = function (_a) {
    var _b = _a === void 0 ? {} : _a, translate = _b.translate, messages = _b.messages;
    return {
        translate: messages
            ? function (key, options) {
                var message = lodashGet(messages, key);
                return message
                    ? typeof message === 'function'
                        ? message(options)
                        : message
                    : (options === null || options === void 0 ? void 0 : options._) || key;
            }
            : translate || (function (key) { return key; }),
        changeLocale: function () { return Promise.resolve(); },
        getLocale: function () { return 'en'; },
    };
};
//# sourceMappingURL=TestTranslationProvider.js.map