var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import merge from 'lodash/merge';
import { DEFAULT_LOCALE } from './index';
/**
 * Resolve the browser locale according to the value of the global window.navigator
 *
 * Use it to determine the <Admin> locale at runtime.
 *
 * @example
 *    import * as React from "react";
 *    import { Admin, Resource, resolveBrowserLocale } from 'react-admin';
 *    import polyglotI18nProvider from 'ra-i18n-polyglot';
 *    import englishMessages from 'ra-language-english';
 *    import frenchMessages from 'ra-language-french';
 *
 *    const messages = {
 *        fr: frenchMessages,
 *        en: englishMessages,
 *    };
 *    const i18nProvider = polyglotI18nProvider(
 *        locale => messages[locale] ? messages[locale] : messages.en,
 *        resolveBrowserLocale()
 *    );
 *
 *    const App = () => (
 *        <Admin i18nProvider={i18nProvider}>
 *            ...
 *        </Admin>
 *    );
 *
 * @param {string} defaultLocale Defaults to 'en'
 * @param options
 * @param {boolean} options.fullLocale Defaults to false
 */
export var resolveBrowserLocale = function (defaultLocale, options) {
    // from http://blog.ksol.fr/user-locale-detection-browser-javascript/
    // Rely on the window.navigator object to determine user locale
    var _a = window.navigator, language = _a.language, browserLanguage = _a.browserLanguage, userLanguage = _a.userLanguage;
    var locale = language ||
        browserLanguage ||
        userLanguage ||
        defaultLocale ||
        DEFAULT_LOCALE;
    return (options === null || options === void 0 ? void 0 : options.fullLocale) ? locale : locale.split('-')[0];
};
/**
 * Compose translations from multiple packages for a single language (eg: 'english').
 *
 * Use it to merge translations from addons with the main react-admin translations.
 *
 * @example
 *     import * as React from "react";
 *     import { Admin, Resource, mergeTranslations } from 'react-admin';
 *     import polyglotI18nProvider from 'ra-i18n-polyglot';
 *     import englishMessages from 'ra-language-english';
 *     import englishTreeMessages from 'ra-tree-language-english';
 *
 *     const messages = {
 *        en: mergeTranslations(englishMessages, englishTreeMessages),
 *     };
 *     const i18nProvider = polyglotI18nProvider(
 *        locale => messages[locale] ? messages[locale] : messages.en
 *    );
 *
 *    const App = () => (
 *        <Admin i18nProvider={i18nProvider}>
 *            ...
 *        </Admin>
 *    );
 */
export var mergeTranslations = function () {
    var translationsModules = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        translationsModules[_i] = arguments[_i];
    }
    return merge.apply(void 0, __spreadArray([{}], translationsModules, false));
};
//# sourceMappingURL=TranslationUtils.js.map