import { useLocaleState } from './useLocaleState';
/**
 * Get the current locale
 *
 * @example
 *
 * import { useLocale } from 'react-admin';
 *
 * const availableLanguages = {
 *     en: 'English',
 *     fr: 'Français',
 * }
 * const CurrentLanguage = () => {
 *     const locale = useLocale();
 *     return <span>{availableLanguages[locale]}</span>;
 * }
 */
export var useLocale = function () {
    var locale = useLocaleState()[0];
    return locale;
};
//# sourceMappingURL=useLocale.js.map