import { useMemo } from 'react';
import { useI18nProvider } from './useI18nProvider';
/**
 * A hook that gets the available locales from the i18nProvider.
 * @example
 *
 * import { useLocales } from 'react-admin';
 *
 * const LocaleSelector = () => {
 *     const locales = useLocales();
 *     const [currentLocale, setCurrentLocale] = useLocaleState();
 *
 *     return (
 *         <select onChange={event => setCurrentLocale(event.target.value)}>
 *             {locales.map(locale => (
 *                 <option key={locale.locale} value={locale.locale}>
 *                     {locale.name}
 *                 </option>
 *             )}
 *         </select>
 *     );
 * }
 */
export var useLocales = function (options) {
    var _a;
    var i18nProvider = useI18nProvider();
    var locales = useMemo(function () { return ((i18nProvider === null || i18nProvider === void 0 ? void 0 : i18nProvider.getLocales) ? i18nProvider === null || i18nProvider === void 0 ? void 0 : i18nProvider.getLocales() : []); }, [i18nProvider]);
    return (_a = options === null || options === void 0 ? void 0 : options.locales) !== null && _a !== void 0 ? _a : locales;
};
//# sourceMappingURL=useLocales.js.map