import { useCallback } from 'react';
import { useTranslate } from './useTranslate';
import { getFieldLabelTranslationArgs } from '../util';
import { useResourceContext, useOptionalSourceContext } from '../core';
export var useTranslateLabel = function () {
    var translate = useTranslate();
    var resourceFromContext = useResourceContext();
    var sourceContext = useOptionalSourceContext();
    return useCallback(function (_a) {
        var source = _a.source, label = _a.label, resource = _a.resource;
        if (label === false || label === '') {
            return null;
        }
        if (label && typeof label !== 'string') {
            return label;
        }
        return translate.apply(void 0, getFieldLabelTranslationArgs({
            label: label,
            defaultLabel: source
                ? sourceContext === null || sourceContext === void 0 ? void 0 : sourceContext.getLabel(source)
                : undefined,
            resource: resource,
            resourceFromContext: resourceFromContext,
            source: source,
        }));
    }, [resourceFromContext, translate, sourceContext]);
};
//# sourceMappingURL=useTranslateLabel.js.map