import * as React from 'react';
import { useCallback, useMemo, useState } from 'react';
import { PreferencesEditorContext, } from './PreferencesEditorContext';
export var PreferencesEditorContextProvider = function (_a) {
    var children = _a.children;
    var _b = useState(false), isEnabled = _b[0], setIsEnabled = _b[1];
    var _c = useState(null), editor = _c[0], setEditor = _c[1];
    var _d = useState(null), preferenceKey = _d[0], setPreferenceKey = _d[1];
    var _e = useState(null), path = _e[0], setPath = _e[1];
    var _f = useState(null), title = _f[0], setTitleString = _f[1];
    var _g = useState(), titleOptions = _g[0], setTitleOptions = _g[1];
    var enable = useCallback(function () { return setIsEnabled(true); }, []);
    var disable = useCallback(function () {
        setIsEnabled(false);
        setEditor(null);
    }, []);
    var setTitle = useCallback(function (title, titleOptions) {
        setTitleString(title);
        setTitleOptions(titleOptions);
    }, []);
    var context = useMemo(function () {
        return {
            editor: editor,
            setEditor: setEditor,
            preferenceKey: preferenceKey,
            setPreferenceKey: setPreferenceKey,
            title: title,
            titleOptions: titleOptions,
            setTitle: setTitle,
            isEnabled: isEnabled,
            disable: disable,
            enable: enable,
            path: path,
            setPath: setPath,
        };
    }, [
        disable,
        enable,
        editor,
        preferenceKey,
        isEnabled,
        path,
        setPath,
        title,
        titleOptions,
        setTitle,
    ]);
    return (React.createElement(PreferencesEditorContext.Provider, { value: context }, children));
};
//# sourceMappingURL=PreferencesEditorContextProvider.js.map