import { useEffect } from 'react';
import { usePreferencesEditor } from './usePreferencesEditor';
/**
 * Set inspector title on mount
 *
 * @example
 * useSetInspectorTitle('Datagrid');
 */
export var useSetInspectorTitle = function (title, options) {
    var preferencesEditorContext = usePreferencesEditor();
    if (!preferencesEditorContext) {
        throw new Error('useSetInspectorTitle cannot be called outside of a PreferencesEditorContext');
    }
    var setTitle = preferencesEditorContext.setTitle;
    useEffect(function () {
        setTitle(title, options);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [title, JSON.stringify(options), setTitle]);
};
//# sourceMappingURL=useSetInspectorTitle.js.map