import type { RaRecord } from '../types';
import type { LinkToType } from './types';
/**
 * Get a path for a record, based on the current resource and the link type.
 *
 * Accepted link types are 'edit', 'show', a route string, false, or a function returning one of these types.
 *
 * @example
 * // basic usage (leverages RecordContext, ResourceContext and ResourceDefinitionContext)
 * const EditLink = () => {
 *   const path = useGetPathForRecord();
 *   return path ? <Link to={path}>Edit</Link> : null;
 * };
 *
 * // controlled mode
 * const EditLink = ({ record, resource }) => {
 *    const path = useGetPathForRecord({ record, resource, link: 'edit' });
 *    return path ? <Link to={path}>Edit</Link> : null;
 * };
 *
 * // the link option can be a function
 * const EditLink = ({ record, resource }) => {
 *   const path = useGetPathForRecord({ record, resource, link: (record, resource) => record.canEdit ? 'edit' : false });
 *   return path ? <Link to={path}>Edit</Link> : null;
 * };
 *
 * // the link option can be a function returning a promise
 * const EditLink = ({ record, resource }) => {
 *   const path = useGetPathForRecord({ record, resource, link: async (record, resource) => {
 *     const canEdit = await canEditRecord(record, resource);
 *     return canEdit ? 'edit' : false;
 *   }});
 *   return path ? <Link to={path}>Edit</Link> : null;
 * };
 */
export declare const useGetPathForRecord: <RecordType extends RaRecord<import("../types").Identifier> = RaRecord<import("../types").Identifier>>(options?: UseGetPathForRecordOptions<RecordType>) => string | false | undefined;
export interface UseGetPathForRecordOptions<RecordType extends RaRecord = RaRecord> {
    resource?: string;
    record?: RecordType;
    link?: LinkToType<RecordType>;
}
export type UseGetRouteForRecordOptions<RecordType extends RaRecord = RaRecord> = UseGetPathForRecordOptions<RecordType>;
//# sourceMappingURL=useGetPathForRecord.d.ts.map