var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { useCallback } from 'react';
import { useResourceContext } from '../core/useResourceContext';
import { useResourceDefinitions } from '../core/useResourceDefinitions';
import { useCanAccessCallback } from '../auth/useCanAccessCallback';
import { useCreatePath } from './useCreatePath';
export var useGetPathForRecordCallback = function (options) {
    if (options === void 0) { options = {}; }
    var resource = useResourceContext(options);
    var resourceDefinitions = useResourceDefinitions();
    var createPath = useCreatePath();
    var canAccess = useCanAccessCallback();
    return useCallback(function (params) { return __awaiter(void 0, void 0, void 0, function () {
        var _a, link, record, finalResource, resourceDefinition, _b, canAccessShow, canAccessEdit, linkFunc, linkResult, linkResultIsPromise, resolvedLink;
        var _c, _d;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    _a = params || {}, link = _a.link, record = _a.record;
                    finalResource = (_c = params.resource) !== null && _c !== void 0 ? _c : resource;
                    if (!finalResource) {
                        throw new Error('Cannot generate a link for a record without a resource. You must use useGetPathForRecordCallback within a ResourceContextProvider, or pass a resource parameter.');
                    }
                    resourceDefinition = (_d = resourceDefinitions[finalResource]) !== null && _d !== void 0 ? _d : {};
                    if (record == null || link === false) {
                        return [2 /*return*/, false];
                    }
                    if (!(link == null)) return [3 /*break*/, 2];
                    return [4 /*yield*/, Promise.all([
                            resourceDefinition.hasShow
                                ? canAccess({
                                    action: 'show',
                                    resource: finalResource,
                                    record: record,
                                })
                                : Promise.resolve(false),
                            resourceDefinition.hasEdit
                                ? canAccess({
                                    action: 'edit',
                                    resource: finalResource,
                                    record: record,
                                })
                                : Promise.resolve(false),
                        ])];
                case 1:
                    _b = _e.sent(), canAccessShow = _b[0], canAccessEdit = _b[1];
                    if (canAccessShow) {
                        return [2 /*return*/, createPath({
                                resource: finalResource,
                                id: record.id,
                                type: 'show',
                            })];
                    }
                    if (canAccessEdit) {
                        return [2 /*return*/, createPath({
                                resource: finalResource,
                                id: record.id,
                                type: 'edit',
                            })];
                    }
                    return [2 /*return*/, false];
                case 2:
                    linkFunc = typeof link === 'function' ? link : function () { return link; };
                    linkResult = linkFunc(record, finalResource);
                    if (linkResult === false) {
                        return [2 /*return*/, false];
                    }
                    linkResultIsPromise = isPromise(linkResult);
                    if (!linkResultIsPromise) return [3 /*break*/, 4];
                    return [4 /*yield*/, linkResult];
                case 3:
                    resolvedLink = _e.sent();
                    if (resolvedLink === false) {
                        // already set to false by default
                        return [2 /*return*/];
                    }
                    return [2 /*return*/, createPath({
                            resource: finalResource,
                            id: record.id,
                            type: resolvedLink,
                        })];
                case 4: return [2 /*return*/, createPath({
                        resource: finalResource,
                        id: record.id,
                        type: linkResult,
                    })];
            }
        });
    }); }, [canAccess, createPath, resourceDefinitions, resource]);
};
var isPromise = function (value) {
    return value && typeof value.then === 'function';
};
//# sourceMappingURL=useGetPathForRecordCallback.js.map