import { Store } from './types';
/**
 * Store using localStorage, or memory storage in incognito mode
 *
 * @example
 *
 * import { localStorageStore } from 'react-admin';
 *
 * const App = () => (
 *    <Admin store={localStorageStore()}>
 *       ...
 *   </Admin>
 * );
 */
export declare const localStorageStore: (version?: string, appKey?: string) => Store;
declare class LocalStorageShim {
    valuesMap: any;
    getItem(key: string): string | null;
    setItem(key: string, value: string): void;
    removeItem(key: string): void;
    removeItems(keyPrefix: string): void;
    clear(): void;
    key(i: any): string;
    get length(): any;
}
export declare const getStorage: () => LocalStorageShim | Storage;
export {};
//# sourceMappingURL=localStorageStore.d.ts.map