import { useCallback } from 'react';
import { useStoreContext } from './useStoreContext';
/**
 * Get a callback to remove an item from the store
 *
 * @example
 * import { useRemoveFromStore } from 'react-admin';
 *
 * const ResetDatagridPrefs = () {
 *    const removeItem = useRemoveFromStore();
 *
 *    const handleClick = () => {
 *        removeItem('datagrid.prefs');
 *    };
 *
 *    return <Button onClick={hancleClick}>Reset datagrid preferences</Button>;
 * }
 */
export var useRemoveFromStore = function (hookTimeKey) {
    var removeItem = useStoreContext().removeItem;
    return useCallback(function (key) {
        if (typeof key === 'undefined' &&
            typeof hookTimeKey === 'undefined') {
            throw new Error('You must provide a key to remove an item from the store');
        }
        // @ts-ignore
        return removeItem(key !== null && key !== void 0 ? key : hookTimeKey);
    }, [removeItem, hookTimeKey]);
};
//# sourceMappingURL=useRemoveFromStore.js.map