import * as React from 'react';
import { memo } from 'react';
import { useTranslateLabel } from '../i18n';
export var FieldTitle = function (props) {
    var source = props.source, label = props.label, resource = props.resource, isRequired = props.isRequired;
    var translateLabel = useTranslateLabel();
    if (label === true) {
        throw new Error('Label parameter must be a string, a ReactElement or false');
    }
    if (label === false || label === '') {
        return null;
    }
    if (label && typeof label !== 'string') {
        return label;
    }
    return (React.createElement("span", null,
        translateLabel({
            label: label,
            resource: resource,
            source: source,
        }),
        isRequired && React.createElement("span", { "aria-hidden": "true" }, "\u2009*")));
};
// What? TypeScript loses the displayName if we don't set it explicitly
FieldTitle.displayName = 'FieldTitle';
export default memo(FieldTitle);
//# sourceMappingURL=FieldTitle.js.map