import { useState, useRef, useEffect, useCallback } from 'react';
import isEqual from 'lodash/isEqual';
// thanks Kent C Dodds for the following helpers
export function useSafeSetState(initialState) {
    var _a = useState(initialState), state = _a[0], setState = _a[1];
    var mountedRef = useRef(false);
    useEffect(function () {
        mountedRef.current = true;
        return function () {
            mountedRef.current = false;
        };
    }, []);
    var safeSetState = useCallback(function (args) {
        if (mountedRef.current) {
            return setState(args);
        }
    }, [mountedRef, setState]);
    return [state, safeSetState];
}
export function usePrevious(value) {
    var ref = useRef();
    useEffect(function () {
        ref.current = value;
    });
    return ref.current;
}
export function useDeepCompareEffect(callback, inputs) {
    var cleanupRef = useRef();
    useEffect(function () {
        if (!isEqual(previousInputs, inputs)) {
            cleanupRef.current = callback();
        }
        return cleanupRef.current;
    });
    var previousInputs = usePrevious(inputs);
}
/**
 * A hook that returns true once a delay has expired.
 * @param ms The delay in milliseconds
 * @param key A key that can be used to reset the timer
 * @returns true if the delay has expired, false otherwise
 */
export function useTimeout(ms, key) {
    if (ms === void 0) { ms = 0; }
    if (key === void 0) { key = ''; }
    var _a = useSafeSetState(false), ready = _a[0], setReady = _a[1];
    useEffect(function () {
        setReady(false);
        var timer = setTimeout(function () {
            setReady(true);
        }, ms);
        return function () {
            clearTimeout(timer);
        };
    }, [key, ms, setReady]);
    return ready;
}
export function useIsMounted() {
    var isMounted = useRef(true);
    useEffect(function () {
        isMounted.current = true;
        return function () {
            isMounted.current = false;
        };
    }, []);
    return isMounted;
}
//# sourceMappingURL=hooks.js.map