import { I18nProvider, TranslationMessages, Locale } from 'ra-core';
type GetMessages = (locale: string) => TranslationMessages | Promise<TranslationMessages>;
/**
 * Build a polyglot-based i18nProvider based on a function returning the messages for a locale
 *
 * @example
 *
 * import { Admin, Resource, polyglotI18nProvider } from 'react-admin';
 * import englishMessages from 'ra-language-english';
 * import frenchMessages from 'ra-language-french';
 *
 * const messages = {
 *     fr: frenchMessages,
 *     en: englishMessages,
 * };
 * const i18nProvider = polyglotI18nProvider(
 *     locale => messages[locale],
 *     'en',
 *     [{ locale: 'en', name: 'English' }, { locale: 'fr', name: 'Français' }]
 * )
 */
declare const _default: (getMessages: GetMessages, initialLocale?: string, availableLocales?: Locale[] | any, polyglotOptions?: any) => I18nProvider;
export default _default;
//# sourceMappingURL=index.d.ts.map