var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
import React, { Children, cloneElement } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import classNames from 'classnames';
import MuiAppBar from '@material-ui/core/AppBar';
import Toolbar from '@material-ui/core/Toolbar';
import IconButton from '@material-ui/core/IconButton';
import Typography from '@material-ui/core/Typography';
import { withStyles, createStyles } from '@material-ui/core/styles';
import MenuIcon from '@material-ui/icons/Menu';
import withWidth from '@material-ui/core/withWidth';
import compose from 'recompose/compose';
import { toggleSidebar as toggleSidebarAction } from 'ra-core';
import LoadingIndicator from './LoadingIndicator';
import UserMenu from './UserMenu';
import Headroom from './Headroom';
var styles = function (theme) { return createStyles({
    toolbar: {
        paddingRight: 24,
    },
    menuButton: {
        marginLeft: '0.5em',
        marginRight: '0.5em',
    },
    menuButtonIconClosed: {
        transition: theme.transitions.create(['transform'], {
            easing: theme.transitions.easing.sharp,
            duration: theme.transitions.duration.leavingScreen,
        }),
        transform: 'rotate(0deg)',
    },
    menuButtonIconOpen: {
        transition: theme.transitions.create(['transform'], {
            easing: theme.transitions.easing.sharp,
            duration: theme.transitions.duration.leavingScreen,
        }),
        transform: 'rotate(180deg)',
    },
    title: {
        flex: 1,
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        overflow: 'hidden',
    },
}); };
var AppBar = function (_a) {
    var children = _a.children, classes = _a.classes, className = _a.className, logo = _a.logo, logout = _a.logout, open = _a.open, title = _a.title, toggleSidebar = _a.toggleSidebar, userMenu = _a.userMenu, width = _a.width, rest = __rest(_a, ["children", "classes", "className", "logo", "logout", "open", "title", "toggleSidebar", "userMenu", "width"]);
    return (React.createElement(Headroom, null,
        React.createElement(MuiAppBar, __assign({ className: className, color: "secondary", position: "static" }, rest),
            React.createElement(Toolbar, { disableGutters: true, variant: width === 'xs' ? 'regular' : 'dense', className: classes.toolbar },
                React.createElement(IconButton, { color: "inherit", "aria-label": "open drawer", onClick: toggleSidebar, className: classNames(classes.menuButton) },
                    React.createElement(MenuIcon, { classes: {
                            root: open
                                ? classes.menuButtonIconOpen
                                : classes.menuButtonIconClosed,
                        } })),
                Children.count(children) === 0 ? (React.createElement(Typography, { variant: "title", color: "inherit", className: classes.title, id: "react-admin-title" })) : (children),
                React.createElement(LoadingIndicator, null),
                cloneElement(userMenu, { logout: logout })))));
};
AppBar.propTypes = {
    children: PropTypes.node,
    classes: PropTypes.object,
    className: PropTypes.string,
    logout: PropTypes.element,
    open: PropTypes.bool,
    title: PropTypes.oneOfType([PropTypes.string, PropTypes.element])
        .isRequired,
    toggleSidebar: PropTypes.func.isRequired,
    userMenu: PropTypes.node,
    width: PropTypes.string,
};
AppBar.defaultProps = {
    userMenu: React.createElement(UserMenu, null),
};
var enhance = compose(connect(function (state) { return ({
    locale: state.i18n.locale,
}); }, {
    toggleSidebar: toggleSidebarAction,
}), withStyles(styles), withWidth());
export default enhance(AppBar);
