"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var onlyUpdateForKeys_1 = __importDefault(require("recompose/onlyUpdateForKeys"));
var Button_1 = __importDefault(require("@material-ui/core/Button"));
var styles_1 = require("@material-ui/core/styles");
var Add_1 = __importDefault(require("@material-ui/icons/Add"));
var compose_1 = __importDefault(require("recompose/compose"));
var classnames_1 = __importDefault(require("classnames"));
var react_router_dom_1 = require("react-router-dom");
var ra_core_1 = require("ra-core");
var Button_2 = __importDefault(require("./Button"));
var Responsive_1 = __importDefault(require("../layout/Responsive"));
var styles = function (theme) {
    return styles_1.createStyles({
        floating: {
            color: theme.palette.getContrastText(theme.palette.primary.main),
            margin: 0,
            top: 'auto',
            right: 20,
            bottom: 60,
            left: 'auto',
            position: 'fixed',
            zIndex: 1000,
        },
        floatingLink: {
            color: 'inherit',
        },
    });
};
var CreateButton = function (_a) {
    var _b = _a.basePath, basePath = _b === void 0 ? '' : _b, className = _a.className, _c = _a.classes, classes = _c === void 0 ? {} : _c, translate = _a.translate, _d = _a.label, label = _d === void 0 ? 'ra.action.create' : _d, _e = _a.icon, icon = _e === void 0 ? react_1.default.createElement(Add_1.default, null) : _e, rest = __rest(_a, ["basePath", "className", "classes", "translate", "label", "icon"]);
    return (react_1.default.createElement(Responsive_1.default, { small: react_1.default.createElement(Button_1.default, __assign({ component: react_router_dom_1.Link, variant: "fab", color: "primary", className: classnames_1.default(classes.floating, className), to: basePath + "/create", "aria-label": label && translate(label) }, rest), icon), medium: react_1.default.createElement(Button_2.default, __assign({ component: react_router_dom_1.Link, to: basePath + "/create", className: className, label: label }, rest), icon) }));
};
CreateButton.propTypes = {
    basePath: prop_types_1.default.string,
    className: prop_types_1.default.string,
    classes: prop_types_1.default.object,
    label: prop_types_1.default.string,
    size: prop_types_1.default.string,
    translate: prop_types_1.default.func.isRequired,
    icon: prop_types_1.default.element,
};
var enhance = compose_1.default(ra_core_1.translate, onlyUpdateForKeys_1.default(['basePath', 'label', 'translate']), styles_1.withStyles(styles));
exports.default = enhance(CreateButton);
