"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_redux_1 = require("react-redux");
var GetApp_1 = __importDefault(require("@material-ui/icons/GetApp"));
var ra_core_1 = require("ra-core");
var papaparse_min_1 = require("papaparse/papaparse.min");
var Button_1 = __importDefault(require("./Button"));
var sanitizeRestProps = function (_a) {
    var basePath = _a.basePath, crudGetAll = _a.crudGetAll, dispatch = _a.dispatch, exporter = _a.exporter, filter = _a.filter, maxResults = _a.maxResults, resource = _a.resource, sort = _a.sort, rest = __rest(_a, ["basePath", "crudGetAll", "dispatch", "exporter", "filter", "maxResults", "resource", "sort"]);
    return rest;
};
/**
 * Extracts, aggregates and deduplicates the ids of related records
 *
 * @example
 *     const books = [
 *         { id: 1, author_id: 123, title: 'Pride and Prejudice' },
 *         { id: 2, author_id: 123, title: 'Sense and Sensibility' },
 *         { id: 3, author_id: 456, title: 'War and Peace' },
 *     ];
 *     getRelatedIds(books, 'author_id'); => [123, 456]
 *
 * @example
 *     const books = [
 *         { id: 1, tag_ids: [1, 2], title: 'Pride and Prejudice' },
 *         { id: 2, tag_ids: [2, 3], title: 'Sense and Sensibility' },
 *         { id: 3, tag_ids: [4], title: 'War and Peace' },
 *     ];
 *     getRelatedIds(records, 'tag_ids'); => [1, 2, 3, 4]
 *
 * @param {Object[]} records An array of records
 * @param {string} field the identifier of the record field to use
 */
exports.getRelatedIds = function (records, field) {
    return Array.from(new Set(records
        .filter(function (record) { return record[field] != null; })
        .map(function (record) { return record[field]; })
        .reduce(function (ids, value) { return ids.concat(value); }, [])));
};
/**
 * Helper function for calling the data provider with GET_MANY
 * via redux and saga, and getting a Promise in return
 *
 * @example
 *     fetchRelatedRecords(records, 'post_id', 'posts').then(posts =>
 *          posts.map(record => ({
 *              ...record,
 *              post_title: posts[record.post_id].title,
 *          }));
 */
var fetchRelatedRecords = function (dispatch) { return function (data, field, resource) {
    return new Promise(function (resolve, reject) {
        dispatch({
            type: ra_core_1.CRUD_GET_MANY,
            payload: { ids: exports.getRelatedIds(data, field) },
            meta: {
                resource: resource,
                fetch: ra_core_1.GET_MANY,
                onSuccess: {
                    callback: function (_a) {
                        var data = _a.payload.data;
                        resolve(data.reduce(function (acc, post) {
                            acc[post.id] = post;
                            return acc;
                        }, {}));
                    },
                },
                onFailure: {
                    notification: {
                        body: 'ra.notification.http_error',
                        level: 'warning',
                    },
                    callback: function (_a) {
                        var error = _a.error;
                        return reject(error);
                    },
                },
            },
        });
    });
}; };
var ExportButton = /** @class */ (function (_super) {
    __extends(ExportButton, _super);
    function ExportButton() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.handleClick = function () {
            var _a = _this.props, dispatch = _a.dispatch, exporter = _a.exporter, filter = _a.filter, maxResults = _a.maxResults, sort = _a.sort, resource = _a.resource, onClick = _a.onClick;
            dispatch(ra_core_1.crudGetAll(resource, sort, filter, maxResults, function (_a) {
                var data = _a.payload.data;
                return exporter
                    ? exporter(data, fetchRelatedRecords(dispatch), dispatch)
                    : ra_core_1.downloadCSV(papaparse_min_1.unparse(data), resource);
            }));
            if (typeof onClick === 'function') {
                onClick();
            }
        };
        return _this;
    }
    ExportButton.prototype.render = function () {
        var _a = this.props, label = _a.label, icon = _a.icon, rest = __rest(_a, ["label", "icon"]);
        return (react_1.default.createElement(Button_1.default, __assign({ onClick: this.handleClick, label: label }, sanitizeRestProps(rest)), icon));
    };
    ExportButton.propTypes = {
        basePath: prop_types_1.default.string,
        dispatch: prop_types_1.default.func,
        exporter: prop_types_1.default.func,
        filter: prop_types_1.default.object,
        label: prop_types_1.default.string,
        maxResults: prop_types_1.default.number.isRequired,
        resource: prop_types_1.default.string.isRequired,
        sort: prop_types_1.default.object,
        icon: prop_types_1.default.element,
    };
    ExportButton.defaultProps = {
        label: 'ra.action.export',
        maxResults: 1000,
        icon: react_1.default.createElement(GetApp_1.default, null),
    };
    return ExportButton;
}(react_1.Component));
exports.default = react_redux_1.connect()(ExportButton); // inject redux dispatch
