"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_redux_1 = require("react-redux");
var compose_1 = __importDefault(require("recompose/compose"));
var Tooltip_1 = __importDefault(require("@material-ui/core/Tooltip"));
var IconButton_1 = __importDefault(require("@material-ui/core/IconButton"));
var Refresh_1 = __importDefault(require("@material-ui/icons/Refresh"));
var ra_core_1 = require("ra-core");
var RefreshButton = /** @class */ (function (_super) {
    __extends(RefreshButton, _super);
    function RefreshButton() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.handleClick = function (event) {
            var _a = _this.props, refreshView = _a.refreshView, onClick = _a.onClick;
            event.preventDefault();
            refreshView();
            if (typeof onClick === 'function') {
                onClick();
            }
        };
        return _this;
    }
    RefreshButton.prototype.render = function () {
        var _a = this.props, className = _a.className, label = _a.label, refreshView = _a.refreshView, translate = _a.translate, icon = _a.icon, rest = __rest(_a, ["className", "label", "refreshView", "translate", "icon"]);
        return (react_1.default.createElement(Tooltip_1.default, { title: label && translate(label, { _: label }) },
            react_1.default.createElement(IconButton_1.default, __assign({ "aria-label": label && translate(label, { _: label }), className: className, color: "inherit", onClick: this.handleClick }, rest), icon)));
    };
    RefreshButton.propTypes = {
        className: prop_types_1.default.string,
        label: prop_types_1.default.string,
        refreshView: prop_types_1.default.func.isRequired,
        translate: prop_types_1.default.func.isRequired,
        icon: prop_types_1.default.element,
    };
    RefreshButton.defaultProps = {
        label: 'ra.action.refresh',
        icon: react_1.default.createElement(Refresh_1.default, null),
    };
    return RefreshButton;
}(react_1.Component));
var enhance = compose_1.default(react_redux_1.connect(null, { refreshView: ra_core_1.refreshView }), ra_core_1.translate);
exports.default = enhance(RefreshButton);
