"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_redux_1 = require("react-redux");
var compose_1 = __importDefault(require("recompose/compose"));
var Button_1 = __importDefault(require("@material-ui/core/Button"));
var CircularProgress_1 = __importDefault(require("@material-ui/core/CircularProgress"));
var styles_1 = require("@material-ui/core/styles");
var Save_1 = __importDefault(require("@material-ui/icons/Save"));
var classnames_1 = __importDefault(require("classnames"));
var ra_core_1 = require("ra-core");
var styles = styles_1.createStyles({
    button: {
        position: 'relative',
    },
    iconPaddingStyle: {
        marginRight: '0.5em',
    },
});
var sanitizeRestProps = function (_a) {
    var basePath = _a.basePath, className = _a.className, classes = _a.classes, saving = _a.saving, label = _a.label, invalid = _a.invalid, variant = _a.variant, translate = _a.translate, handleSubmit = _a.handleSubmit, handleSubmitWithRedirect = _a.handleSubmitWithRedirect, submitOnEnter = _a.submitOnEnter, record = _a.record, redirect = _a.redirect, resource = _a.resource, locale = _a.locale, showNotification = _a.showNotification, rest = __rest(_a, ["basePath", "className", "classes", "saving", "label", "invalid", "variant", "translate", "handleSubmit", "handleSubmitWithRedirect", "submitOnEnter", "record", "redirect", "resource", "locale", "showNotification"]);
    return rest;
};
var SaveButton = /** @class */ (function (_super) {
    __extends(SaveButton, _super);
    function SaveButton() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.handleClick = function (e) {
            var _a = _this.props, handleSubmitWithRedirect = _a.handleSubmitWithRedirect, invalid = _a.invalid, redirect = _a.redirect, saving = _a.saving, showNotification = _a.showNotification, onClick = _a.onClick;
            if (saving) {
                // prevent double submission
                e.preventDefault();
            }
            else {
                if (invalid) {
                    showNotification('ra.message.invalid_form', 'warning');
                }
                // always submit form explicitly regardless of button type
                if (e) {
                    e.preventDefault();
                }
                handleSubmitWithRedirect(redirect)();
            }
            if (typeof onClick === 'function') {
                onClick();
            }
        };
        return _this;
    }
    SaveButton.prototype.render = function () {
        var _a = this.props, className = _a.className, _b = _a.classes, classes = _b === void 0 ? {} : _b, invalid = _a.invalid, _c = _a.label, label = _c === void 0 ? 'ra.action.save' : _c, pristine = _a.pristine, redirect = _a.redirect, saving = _a.saving, submitOnEnter = _a.submitOnEnter, translate = _a.translate, _d = _a.variant, variant = _d === void 0 ? 'raised' : _d, icon = _a.icon, onClick = _a.onClick, rest = __rest(_a, ["className", "classes", "invalid", "label", "pristine", "redirect", "saving", "submitOnEnter", "translate", "variant", "icon", "onClick"]);
        var type = submitOnEnter ? 'submit' : 'button';
        return (react_1.default.createElement(Button_1.default, __assign({ className: classnames_1.default(classes.button, className), variant: variant, type: type, onClick: this.handleClick, color: saving ? 'default' : 'primary' }, sanitizeRestProps(rest)),
            saving && saving.redirect === redirect ? (react_1.default.createElement(CircularProgress_1.default, { size: 25, thickness: 2, className: classes.iconPaddingStyle })) : (react_1.default.cloneElement(icon, {
                className: classes.iconPaddingStyle,
            })),
            label && translate(label, { _: label })));
    };
    SaveButton.propTypes = {
        className: prop_types_1.default.string,
        classes: prop_types_1.default.object,
        handleSubmitWithRedirect: prop_types_1.default.func,
        invalid: prop_types_1.default.bool,
        label: prop_types_1.default.string,
        pristine: prop_types_1.default.bool,
        redirect: prop_types_1.default.oneOfType([
            prop_types_1.default.string,
            prop_types_1.default.bool,
            prop_types_1.default.func,
        ]),
        saving: prop_types_1.default.oneOfType([prop_types_1.default.object, prop_types_1.default.bool]),
        showNotification: prop_types_1.default.func,
        submitOnEnter: prop_types_1.default.bool,
        translate: prop_types_1.default.func.isRequired,
        variant: prop_types_1.default.oneOf(['raised', 'flat', 'fab']),
        icon: prop_types_1.default.element,
    };
    SaveButton.defaultProps = {
        handleSubmitWithRedirect: function () { return function () { }; },
        icon: react_1.default.createElement(Save_1.default, null),
    };
    return SaveButton;
}(react_1.Component));
exports.SaveButton = SaveButton;
var enhance = compose_1.default(ra_core_1.translate, react_redux_1.connect(undefined, { showNotification: ra_core_1.showNotification }), styles_1.withStyles(styles));
exports.default = enhance(SaveButton);
