"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var Datagrid_1 = __importDefault(require("../list/Datagrid"));
var ArrayField_1 = __importDefault(require("../field/ArrayField"));
var BooleanField_1 = __importDefault(require("../field/BooleanField"));
var DateField_1 = __importDefault(require("../field/DateField"));
var EmailField_1 = __importDefault(require("../field/EmailField"));
var NumberField_1 = __importDefault(require("../field/NumberField"));
var ReferenceField_1 = __importDefault(require("../field/ReferenceField"));
var ReferenceArrayField_1 = __importDefault(require("../field/ReferenceArrayField"));
var RichTextField_1 = __importDefault(require("../field/RichTextField"));
var SimpleShowLayout_1 = __importDefault(require("./SimpleShowLayout"));
var TextField_1 = __importDefault(require("../field/TextField"));
var UrlField_1 = __importDefault(require("../field/UrlField"));
exports.default = {
    show: {
        component: function (props) { return react_1.default.createElement(SimpleShowLayout_1.default, __assign({}, props)); },
        representation: function (_, children) { return "        <SimpleShowLayout>\n" + children.map(function (child) { return "            " + child.getRepresentation(); }).join('\n') + "\n        </SimpleShowLayout>"; },
    },
    array: {
        // eslint-disable-next-line react/display-name
        component: function (_a) {
            var children = _a.children, props = __rest(_a, ["children"]);
            return (react_1.default.createElement(ArrayField_1.default, __assign({}, props),
                react_1.default.createElement(Datagrid_1.default, null, children)));
        },
        representation: function (props, children) {
            return "<ArrayField source=\"" + props.source + "\"><Datagrid>" + children
                .map(function (child) { return child.getRepresentation(); })
                .join('\n') + "</Datagrid></ArrayField>";
        },
    },
    boolean: {
        component: BooleanField_1.default,
        representation: function (props) { return "<BooleanField source=\"" + props.source + "\" />"; },
    },
    date: {
        component: DateField_1.default,
        representation: function (props) { return "<DateField source=\"" + props.source + "\" />"; },
    },
    email: {
        component: EmailField_1.default,
        representation: function (props) { return "<EmailField source=\"" + props.source + "\" />"; },
    },
    id: {
        component: TextField_1.default,
        representation: function (props) { return "<TextField source=\"" + props.source + "\" />"; },
    },
    number: {
        component: NumberField_1.default,
        representation: function (props) { return "<NumberField source=\"" + props.source + "\" />"; },
    },
    reference: {
        component: ReferenceField_1.default,
        representation: function (props) {
            return "<ReferenceField source=\"" + props.source + "\" reference=\"" + props.reference + "\"><TextField source=\"id\" /></ReferenceField>";
        },
    },
    referenceChild: {
        component: function (props) { return react_1.default.createElement(TextField_1.default, __assign({ source: "id" }, props)); },
        representation: function () { return "<TextField source=\"id\" />"; },
    },
    referenceArray: {
        component: ReferenceArrayField_1.default,
        representation: function (props) {
            return "<ReferenceArrayField source=\"" + props.source + "\" reference=\"" + props.reference + "\"><TextField source=\"id\" /></ReferenceArrayField>";
        },
    },
    referenceArrayChild: {
        component: function (props) { return react_1.default.createElement(TextField_1.default, __assign({ source: "id" }, props)); },
        representation: function () { return "<TextField source=\"id\" />"; },
    },
    richText: {
        component: RichTextField_1.default,
        representation: function (props) { return "<RichTextField source=\"" + props.source + "\" />"; },
    },
    string: {
        component: TextField_1.default,
        representation: function (props) { return "<TextField source=\"" + props.source + "\" />"; },
    },
    url: {
        component: UrlField_1.default,
        representation: function (props) { return "<UrlField source=\"" + props.source + "\" />"; },
    },
};
