"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var compose_1 = __importDefault(require("recompose/compose"));
var Toolbar_1 = __importDefault(require("@material-ui/core/Toolbar"));
var withWidth_1 = __importDefault(require("@material-ui/core/withWidth"));
var styles_1 = require("@material-ui/core/styles");
var classnames_1 = __importDefault(require("classnames"));
var button_1 = require("../button");
var styles = function (theme) {
    var _a;
    return styles_1.createStyles({
        toolbar: {
            backgroundColor: theme.palette.type === 'light'
                ? theme.palette.grey[100]
                : theme.palette.grey[900],
        },
        desktopToolbar: {
            marginTop: theme.spacing.unit * 2,
        },
        mobileToolbar: {
            position: 'fixed',
            bottom: 0,
            left: 0,
            right: 0,
            padding: '16px',
            width: '100%',
            boxSizing: 'border-box',
            flexShrink: 0,
            zIndex: 2,
        },
        defaultToolbar: {
            flex: 1,
            display: 'flex',
            justifyContent: 'space-between',
        },
        spacer: (_a = {},
            _a[theme.breakpoints.down('xs')] = {
                height: '5em',
            },
            _a),
    });
};
var valueOrDefault = function (value, defaultValue) {
    return typeof value === 'undefined' ? defaultValue : value;
};
var Toolbar = function (_a) {
    var basePath = _a.basePath, children = _a.children, classes = _a.classes, className = _a.className, handleSubmit = _a.handleSubmit, handleSubmitWithRedirect = _a.handleSubmitWithRedirect, invalid = _a.invalid, pristine = _a.pristine, record = _a.record, redirect = _a.redirect, resource = _a.resource, saving = _a.saving, submitOnEnter = _a.submitOnEnter, undoable = _a.undoable, width = _a.width, rest = __rest(_a, ["basePath", "children", "classes", "className", "handleSubmit", "handleSubmitWithRedirect", "invalid", "pristine", "record", "redirect", "resource", "saving", "submitOnEnter", "undoable", "width"]);
    var _b;
    return (react_1.default.createElement(react_1.Fragment, null,
        react_1.default.createElement(Toolbar_1.default, __assign({ className: classnames_1.default(classes.toolbar, (_b = {},
                _b[classes.mobileToolbar] = width === 'xs',
                _b[classes.desktopToolbar] = width !== 'xs',
                _b), className), role: "toolbar" }, rest), react_1.Children.count(children) === 0 ? (react_1.default.createElement("div", { className: classes.defaultToolbar },
            react_1.default.createElement(button_1.SaveButton, { handleSubmitWithRedirect: handleSubmitWithRedirect, invalid: invalid, redirect: redirect, saving: saving, submitOnEnter: submitOnEnter }),
            record && typeof record.id !== 'undefined' && (react_1.default.createElement(button_1.DeleteButton, { basePath: basePath, record: record, resource: resource, undoable: undoable })))) : (react_1.Children.map(children, function (button) {
            return button && react_1.isValidElement(button)
                ? react_1.default.cloneElement(button, {
                    basePath: basePath,
                    handleSubmit: valueOrDefault(button.props.handleSubmit, handleSubmit),
                    handleSubmitWithRedirect: valueOrDefault(button.props.handleSubmitWithRedirect, handleSubmitWithRedirect),
                    invalid: invalid,
                    pristine: pristine,
                    record: record,
                    resource: resource,
                    saving: saving,
                    submitOnEnter: valueOrDefault(button.props.submitOnEnter, submitOnEnter),
                    undoable: valueOrDefault(button.props.undoable, undoable),
                })
                : null;
        }))),
        react_1.default.createElement("div", { className: classes.spacer })));
};
Toolbar.propTypes = {
    basePath: prop_types_1.default.string,
    children: prop_types_1.default.node,
    classes: prop_types_1.default.object,
    className: prop_types_1.default.string,
    handleSubmit: prop_types_1.default.func,
    handleSubmitWithRedirect: prop_types_1.default.func,
    invalid: prop_types_1.default.bool,
    pristine: prop_types_1.default.bool,
    record: prop_types_1.default.object,
    redirect: prop_types_1.default.oneOfType([
        prop_types_1.default.string,
        prop_types_1.default.bool,
        prop_types_1.default.func,
    ]),
    resource: prop_types_1.default.string,
    saving: prop_types_1.default.oneOfType([prop_types_1.default.object, prop_types_1.default.bool]),
    submitOnEnter: prop_types_1.default.bool,
    undoable: prop_types_1.default.bool,
    width: prop_types_1.default.string,
};
Toolbar.defaultProps = {
    submitOnEnter: true,
};
var enhance = compose_1.default(withWidth_1.default(), styles_1.withStyles(styles));
exports.default = enhance(Toolbar);
