"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var get_1 = __importDefault(require("lodash/get"));
var FormControl_1 = __importDefault(require("@material-ui/core/FormControl"));
var FormControlLabel_1 = __importDefault(require("@material-ui/core/FormControlLabel"));
var FormHelperText_1 = __importDefault(require("@material-ui/core/FormHelperText"));
var InputLabel_1 = __importDefault(require("@material-ui/core/InputLabel"));
var RadioGroup_1 = __importDefault(require("@material-ui/core/RadioGroup"));
var Radio_1 = __importDefault(require("@material-ui/core/Radio"));
var styles_1 = require("@material-ui/core/styles");
var compose_1 = __importDefault(require("recompose/compose"));
var ra_core_1 = require("ra-core");
var sanitizeRestProps_1 = __importDefault(require("./sanitizeRestProps"));
var styles = styles_1.createStyles({
    label: {
        position: 'relative',
    },
});
/**
 * An Input component for a radio button group, using an array of objects for the options
 *
 * Pass possible options as an array of objects in the 'choices' attribute.
 *
 * By default, the options are built from:
 *  - the 'id' property as the option value,
 *  - the 'name' property an the option text
 * @example
 * const choices = [
 *    { id: 'M', name: 'Male' },
 *    { id: 'F', name: 'Female' },
 * ];
 * <RadioButtonGroupInput source="gender" choices={choices} />
 *
 * You can also customize the properties to use for the option name and value,
 * thanks to the 'optionText' and 'optionValue' attributes.
 * @example
 * const choices = [
 *    { _id: 123, full_name: 'Leo Tolstoi', sex: 'M' },
 *    { _id: 456, full_name: 'Jane Austen', sex: 'F' },
 * ];
 * <RadioButtonGroupInput source="author_id" choices={choices} optionText="full_name" optionValue="_id" />
 *
 * `optionText` also accepts a function, so you can shape the option text at will:
 * @example
 * const choices = [
 *    { id: 123, first_name: 'Leo', last_name: 'Tolstoi' },
 *    { id: 456, first_name: 'Jane', last_name: 'Austen' },
 * ];
 * const optionRenderer = choice => `${choice.first_name} ${choice.last_name}`;
 * <RadioButtonGroupInput source="author_id" choices={choices} optionText={optionRenderer} />
 *
 * `optionText` also accepts a React Element, that will be cloned and receive
 * the related choice as the `record` prop. You can use Field components there.
 * @example
 * const choices = [
 *    { id: 123, first_name: 'Leo', last_name: 'Tolstoi' },
 *    { id: 456, first_name: 'Jane', last_name: 'Austen' },
 * ];
 * const FullNameField = ({ record }) => <span>{record.first_name} {record.last_name}</span>;
 * <RadioButtonGroupInput source="gender" choices={choices} optionText={<FullNameField />}/>
 *
 * The choices are translated by default, so you can use translation identifiers as choices:
 * @example
 * const choices = [
 *    { id: 'M', name: 'myroot.gender.male' },
 *    { id: 'F', name: 'myroot.gender.female' },
 * ];
 *
 * However, in some cases (e.g. inside a `<ReferenceInput>`), you may not want
 * the choice to be translated. In that case, set the `translateChoice` prop to false.
 * @example
 * <RadioButtonGroupInput source="gender" choices={choices} translateChoice={false}/>
 *
 * The object passed as `options` props is passed to the material-ui <RadioButtonGroup> component
 */
var RadioButtonGroupInput = /** @class */ (function (_super) {
    __extends(RadioButtonGroupInput, _super);
    function RadioButtonGroupInput() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.handleChange = function (event, value) {
            _this.props.input.onChange(value);
        };
        _this.renderRadioButton = function (choice) {
            var _a = _this.props, id = _a.id, optionText = _a.optionText, optionValue = _a.optionValue, translate = _a.translate, translateChoice = _a.translateChoice;
            var choiceName = react_1.default.isValidElement(optionText) // eslint-disable-line no-nested-ternary
                ? react_1.default.cloneElement(optionText, { record: choice })
                : typeof optionText === 'function'
                    ? optionText(choice)
                    : get_1.default(choice, optionText);
            return (react_1.default.createElement(FormControlLabel_1.default, { htmlFor: id + "_" + get_1.default(choice, optionValue), key: get_1.default(choice, optionValue), value: get_1.default(choice, optionValue), control: react_1.default.createElement(Radio_1.default, { id: id + "_" + get_1.default(choice, optionValue), color: "primary" }), label: translateChoice
                    ? translate(choiceName, { _: choiceName })
                    : choiceName }));
        };
        return _this;
    }
    RadioButtonGroupInput.prototype.render = function () {
        var _a = this.props, classes = _a.classes, className = _a.className, label = _a.label, resource = _a.resource, source = _a.source, input = _a.input, isRequired = _a.isRequired, choices = _a.choices, options = _a.options, meta = _a.meta, rest = __rest(_a, ["classes", "className", "label", "resource", "source", "input", "isRequired", "choices", "options", "meta"]);
        if (typeof meta === 'undefined') {
            throw new Error("The RadioButtonGroupInput component wasn't called within a redux-form <Field>. Did you decorate it and forget to add the addField prop to your component? See https://marmelab.com/react-admin/Inputs.html#writing-your-own-input-component for details.");
        }
        var touched = meta.touched, error = meta.error, _b = meta.helperText, helperText = _b === void 0 ? false : _b;
        return (react_1.default.createElement(FormControl_1.default, __assign({ component: "fieldset", className: className, margin: "normal" }, sanitizeRestProps_1.default(rest)),
            react_1.default.createElement(InputLabel_1.default, { component: "legend", shrink: true, className: classes.label },
                react_1.default.createElement(ra_core_1.FieldTitle, { label: label, source: source, resource: resource, isRequired: isRequired })),
            react_1.default.createElement(RadioGroup_1.default, __assign({ name: source, value: input.value, onChange: this.handleChange }, options), choices.map(this.renderRadioButton)),
            touched && error && (react_1.default.createElement(FormHelperText_1.default, { error: true }, error)),
            helperText && react_1.default.createElement(FormHelperText_1.default, null, helperText)));
    };
    return RadioButtonGroupInput;
}(react_1.Component));
exports.RadioButtonGroupInput = RadioButtonGroupInput;
RadioButtonGroupInput.propTypes = {
    choices: prop_types_1.default.arrayOf(prop_types_1.default.object),
    classes: prop_types_1.default.object,
    className: prop_types_1.default.string,
    id: prop_types_1.default.string,
    input: prop_types_1.default.object,
    isRequired: prop_types_1.default.bool,
    label: prop_types_1.default.string,
    options: prop_types_1.default.object,
    optionText: prop_types_1.default.oneOfType([
        prop_types_1.default.string,
        prop_types_1.default.func,
        prop_types_1.default.element,
    ]).isRequired,
    optionValue: prop_types_1.default.string.isRequired,
    resource: prop_types_1.default.string,
    source: prop_types_1.default.string,
    translate: prop_types_1.default.func.isRequired,
    translateChoice: prop_types_1.default.bool.isRequired,
    meta: prop_types_1.default.object,
};
RadioButtonGroupInput.defaultProps = {
    classes: {},
    choices: [],
    options: {},
    optionText: 'name',
    optionValue: 'id',
    translateChoice: true,
};
exports.default = compose_1.default(ra_core_1.addField, ra_core_1.translate, styles_1.withStyles(styles))(RadioButtonGroupInput);
