"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_redux_1 = require("react-redux");
var classnames_1 = __importDefault(require("classnames"));
var AppBar_1 = __importDefault(require("@material-ui/core/AppBar"));
var Toolbar_1 = __importDefault(require("@material-ui/core/Toolbar"));
var IconButton_1 = __importDefault(require("@material-ui/core/IconButton"));
var Typography_1 = __importDefault(require("@material-ui/core/Typography"));
var styles_1 = require("@material-ui/core/styles");
var Menu_1 = __importDefault(require("@material-ui/icons/Menu"));
var withWidth_1 = __importDefault(require("@material-ui/core/withWidth"));
var compose_1 = __importDefault(require("recompose/compose"));
var ra_core_1 = require("ra-core");
var LoadingIndicator_1 = __importDefault(require("./LoadingIndicator"));
var UserMenu_1 = __importDefault(require("./UserMenu"));
var Headroom_1 = __importDefault(require("./Headroom"));
var styles = function (theme) { return styles_1.createStyles({
    toolbar: {
        paddingRight: 24,
    },
    menuButton: {
        marginLeft: '0.5em',
        marginRight: '0.5em',
    },
    menuButtonIconClosed: {
        transition: theme.transitions.create(['transform'], {
            easing: theme.transitions.easing.sharp,
            duration: theme.transitions.duration.leavingScreen,
        }),
        transform: 'rotate(0deg)',
    },
    menuButtonIconOpen: {
        transition: theme.transitions.create(['transform'], {
            easing: theme.transitions.easing.sharp,
            duration: theme.transitions.duration.leavingScreen,
        }),
        transform: 'rotate(180deg)',
    },
    title: {
        flex: 1,
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        overflow: 'hidden',
    },
}); };
var AppBar = function (_a) {
    var children = _a.children, classes = _a.classes, className = _a.className, logo = _a.logo, logout = _a.logout, open = _a.open, title = _a.title, toggleSidebar = _a.toggleSidebar, userMenu = _a.userMenu, width = _a.width, rest = __rest(_a, ["children", "classes", "className", "logo", "logout", "open", "title", "toggleSidebar", "userMenu", "width"]);
    return (react_1.default.createElement(Headroom_1.default, null,
        react_1.default.createElement(AppBar_1.default, __assign({ className: className, color: "secondary", position: "static" }, rest),
            react_1.default.createElement(Toolbar_1.default, { disableGutters: true, variant: width === 'xs' ? 'regular' : 'dense', className: classes.toolbar },
                react_1.default.createElement(IconButton_1.default, { color: "inherit", "aria-label": "open drawer", onClick: toggleSidebar, className: classnames_1.default(classes.menuButton) },
                    react_1.default.createElement(Menu_1.default, { classes: {
                            root: open
                                ? classes.menuButtonIconOpen
                                : classes.menuButtonIconClosed,
                        } })),
                react_1.Children.count(children) === 0 ? (react_1.default.createElement(Typography_1.default, { variant: "title", color: "inherit", className: classes.title, id: "react-admin-title" })) : (children),
                react_1.default.createElement(LoadingIndicator_1.default, null),
                react_1.cloneElement(userMenu, { logout: logout })))));
};
AppBar.propTypes = {
    children: prop_types_1.default.node,
    classes: prop_types_1.default.object,
    className: prop_types_1.default.string,
    logout: prop_types_1.default.element,
    open: prop_types_1.default.bool,
    title: prop_types_1.default.oneOfType([prop_types_1.default.string, prop_types_1.default.element])
        .isRequired,
    toggleSidebar: prop_types_1.default.func.isRequired,
    userMenu: prop_types_1.default.node,
    width: prop_types_1.default.string,
};
AppBar.defaultProps = {
    userMenu: react_1.default.createElement(UserMenu_1.default, null),
};
var enhance = compose_1.default(react_redux_1.connect(function (state) { return ({
    locale: state.i18n.locale,
}); }, {
    toggleSidebar: ra_core_1.toggleSidebar,
}), styles_1.withStyles(styles), withWidth_1.default());
exports.default = enhance(AppBar);
