"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_redux_1 = require("react-redux");
var Snackbar_1 = __importDefault(require("@material-ui/core/Snackbar"));
var Button_1 = __importDefault(require("@material-ui/core/Button"));
var styles_1 = require("@material-ui/core/styles");
var compose_1 = __importDefault(require("recompose/compose"));
var classnames_1 = __importDefault(require("classnames"));
var ra_core_1 = require("ra-core");
var styles = function (theme) { return styles_1.createStyles({
    confirm: {
        backgroundColor: theme.palette.background.default,
    },
    warning: {
        backgroundColor: theme.palette.error.light,
    },
    undo: {
        color: theme.palette.primary.light,
    },
}); };
var Notification = /** @class */ (function (_super) {
    __extends(Notification, _super);
    function Notification() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            open: false,
        };
        _this.componentWillMount = function () {
            _this.setOpenState(_this.props);
        };
        _this.componentWillReceiveProps = function (nextProps) {
            _this.setOpenState(nextProps);
        };
        _this.setOpenState = function (_a) {
            var notification = _a.notification;
            _this.setState({
                open: !!notification,
            });
        };
        _this.handleRequestClose = function () {
            _this.setState({
                open: false,
            });
        };
        _this.handleExited = function () {
            var _a = _this.props, notification = _a.notification, hideNotification = _a.hideNotification, complete = _a.complete;
            if (notification && notification.undoable) {
                complete();
            }
            hideNotification();
        };
        return _this;
    }
    Notification.prototype.render = function () {
        var _a = this.props, undo = _a.undo, complete = _a.complete, classes = _a.classes, className = _a.className, type = _a.type, translate = _a.translate, notification = _a.notification, autoHideDuration = _a.autoHideDuration, hideNotification = _a.hideNotification, rest = __rest(_a, ["undo", "complete", "classes", "className", "type", "translate", "notification", "autoHideDuration", "hideNotification"]);
        var warning = classes.warning, confirm = classes.confirm, undoClass = classes.undo, // Rename classes.undo to undoClass in this scope to avoid name conflicts
        snackbarClasses = __rest(classes, ["warning", "confirm", "undo"]);
        return (react_1.default.createElement(Snackbar_1.default, __assign({ open: this.state.open, message: notification &&
                notification.message &&
                translate(notification.message, notification.messageArgs), autoHideDuration: (notification && notification.autoHideDuration) ||
                autoHideDuration, disableWindowBlurListener: notification && notification.undoable, onExited: this.handleExited, onClose: this.handleRequestClose, ContentProps: {
                className: classnames_1.default(classes[(notification && notification.type) || type], className),
            }, action: notification && notification.undoable ? (react_1.default.createElement(Button_1.default, { color: "primary", className: undoClass, size: "small", onClick: undo }, translate('ra.action.undo'))) : null, classes: snackbarClasses }, rest)));
    };
    return Notification;
}(react_1.default.Component));
Notification.propTypes = {
    complete: prop_types_1.default.func,
    classes: prop_types_1.default.object,
    className: prop_types_1.default.string,
    notification: prop_types_1.default.shape({
        message: prop_types_1.default.string,
        type: prop_types_1.default.string,
        autoHideDuration: prop_types_1.default.number,
        messageArgs: prop_types_1.default.object,
    }),
    type: prop_types_1.default.string,
    hideNotification: prop_types_1.default.func.isRequired,
    autoHideDuration: prop_types_1.default.number,
    translate: prop_types_1.default.func.isRequired,
    undo: prop_types_1.default.func,
};
Notification.defaultProps = {
    type: 'info',
    autoHideDuration: 4000,
};
var mapStateToProps = function (state) { return ({
    notification: ra_core_1.getNotification(state),
}); };
exports.default = compose_1.default(ra_core_1.translate, styles_1.withStyles(styles), react_redux_1.connect(mapStateToProps, {
    complete: ra_core_1.complete,
    hideNotification: ra_core_1.hideNotification,
    undo: ra_core_1.undo,
}))(Notification);
