"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var ra_core_1 = require("ra-core");
var styles_1 = require("@material-ui/core/styles");
var Table_1 = __importDefault(require("@material-ui/core/Table"));
var TableCell_1 = __importDefault(require("@material-ui/core/TableCell"));
var TableHead_1 = __importDefault(require("@material-ui/core/TableHead"));
var TableRow_1 = __importDefault(require("@material-ui/core/TableRow"));
var Checkbox_1 = __importDefault(require("@material-ui/core/Checkbox"));
var classnames_1 = __importDefault(require("classnames"));
var DatagridHeaderCell_1 = __importDefault(require("./DatagridHeaderCell"));
var DatagridBody_1 = __importDefault(require("./DatagridBody"));
var DatagridLoading_1 = __importDefault(require("./DatagridLoading"));
var styles = function (theme) { return styles_1.createStyles({
    table: {
        tableLayout: 'auto',
    },
    thead: {},
    tbody: {
        height: 'inherit',
    },
    headerRow: {},
    headerCell: {
        padding: '0 12px',
        '&:last-child': {
            padding: '0 12px',
        },
    },
    checkbox: {},
    row: {},
    clickableRow: {
        cursor: 'pointer',
    },
    rowEven: {},
    rowOdd: {},
    rowCell: {
        padding: '0 12px',
        '&:last-child': {
            padding: '0 12px',
        },
    },
    expandHeader: {
        padding: 0,
        width: 48,
    },
    expandIconCell: {
        width: 48,
    },
    expandIcon: {
        transform: 'rotate(-90deg)',
        transition: theme.transitions.create('transform', {
            duration: theme.transitions.duration.shortest,
        }),
    },
    expanded: {
        transform: 'rotate(0deg)',
    },
}); };
/**
 * The Datagrid component renders a list of records as a table.
 * It is usually used as a child of the <List> and <ReferenceManyField> components.
 *
 * Props:
 *  - rowStyle
 *
 * @example Display all posts as a datagrid
 * const postRowStyle = (record, index) => ({
 *     backgroundColor: record.nb_views >= 500 ? '#efe' : 'white',
 * });
 * export const PostList = (props) => (
 *     <List {...props}>
 *         <Datagrid rowStyle={postRowStyle}>
 *             <TextField source="id" />
 *             <TextField source="title" />
 *             <TextField source="body" />
 *             <EditButton />
 *         </Datagrid>
 *     </List>
 * );
 *
 * @example Display all the comments of the current post as a datagrid
 * <ReferenceManyField reference="comments" target="post_id">
 *     <Datagrid>
 *         <TextField source="id" />
 *         <TextField source="body" />
 *         <DateField source="created_at" />
 *         <EditButton />
 *     </Datagrid>
 * </ReferenceManyField>
 */
var Datagrid = /** @class */ (function (_super) {
    __extends(Datagrid, _super);
    function Datagrid() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.updateSort = function (event) {
            event.stopPropagation();
            _this.props.setSort(event.currentTarget.dataset.sort);
        };
        _this.handleSelectAll = function (event) {
            var _a = _this.props, onSelect = _a.onSelect, ids = _a.ids, selectedIds = _a.selectedIds;
            if (event.target.checked) {
                onSelect(ids.reduce(function (idList, id) {
                    return idList.includes(id) ? idList : idList.concat(id);
                }, selectedIds));
            }
            else {
                onSelect([]);
            }
        };
        return _this;
    }
    Datagrid.prototype.render = function () {
        var _this = this;
        var _a = this.props, basePath = _a.basePath, body = _a.body, children = _a.children, classes = _a.classes, className = _a.className, currentSort = _a.currentSort, data = _a.data, expand = _a.expand, hasBulkActions = _a.hasBulkActions, hover = _a.hover, ids = _a.ids, isLoading = _a.isLoading, loadedOnce = _a.loadedOnce, onSelect = _a.onSelect, onToggleItem = _a.onToggleItem, resource = _a.resource, rowClick = _a.rowClick, rowStyle = _a.rowStyle, selectedIds = _a.selectedIds, setSort = _a.setSort, total = _a.total, version = _a.version, rest = __rest(_a, ["basePath", "body", "children", "classes", "className", "currentSort", "data", "expand", "hasBulkActions", "hover", "ids", "isLoading", "loadedOnce", "onSelect", "onToggleItem", "resource", "rowClick", "rowStyle", "selectedIds", "setSort", "total", "version"]);
        /**
         * if loadedOnce is false, the list displays for the first time, and the dataProvider hasn't answered yet
         * if loadedOnce is true, the data for the list has at least been returned once by the dataProvider
         * if loadedOnce is undefined, the Datagrid parent doesn't track loading state (e.g. ReferenceArrayField)
         */
        if (loadedOnce === false) {
            return (react_1.default.createElement(DatagridLoading_1.default, { classes: classes, className: className, expand: expand, hasBulkActions: hasBulkActions, nbChildren: react_1.default.Children.count(children) }));
        }
        /**
         * Once loaded, the data for the list may be empty. Instead of
         * displaying the table header with zero data rows,
         * the datagrid displays nothing in this case.
         */
        if (!isLoading && (ids.length === 0 || total === 0)) {
            return null;
        }
        /**
         * After the initial load, if the data for the list isn't empty,
         * and even if the data is refreshing (e.g. after a filter change),
         * the datagrid displays the current data.
         */
        return (react_1.default.createElement(Table_1.default, __assign({ className: classnames_1.default(classes.table, className) }, ra_core_1.sanitizeListRestProps(rest)),
            react_1.default.createElement(TableHead_1.default, { className: classes.thead },
                react_1.default.createElement(TableRow_1.default, { className: classnames_1.default(classes.row, classes.headerRow) },
                    expand && (react_1.default.createElement(TableCell_1.default, { className: classes.expandHeader })),
                    hasBulkActions && (react_1.default.createElement(TableCell_1.default, { padding: "none" },
                        react_1.default.createElement(Checkbox_1.default, { className: "select-all", color: "primary", checked: selectedIds.length > 0 &&
                                ids.length > 0 &&
                                !ids.find(function (it) { return selectedIds.indexOf(it) === -1; }), onChange: this.handleSelectAll }))),
                    react_1.Children.map(children, function (field, index) {
                        return react_1.isValidElement(field) ? (react_1.default.createElement(DatagridHeaderCell_1.default, { className: classes.headerCell, currentSort: currentSort, field: field, isSorting: currentSort.field ===
                                (field.props.sortBy ||
                                    field.props.source), key: field.props.source || index, resource: resource, updateSort: _this.updateSort })) : null;
                    }))),
            react_1.cloneElement(body, {
                basePath: basePath,
                className: classes.tbody,
                classes: classes,
                expand: expand,
                rowClick: rowClick,
                data: data,
                hasBulkActions: hasBulkActions,
                hover: hover,
                ids: ids,
                isLoading: isLoading,
                onToggleItem: onToggleItem,
                resource: resource,
                rowStyle: rowStyle,
                selectedIds: selectedIds,
                version: version,
            }, children)));
    };
    return Datagrid;
}(react_1.Component));
Datagrid.propTypes = {
    basePath: prop_types_1.default.string,
    body: prop_types_1.default.element.isRequired,
    children: prop_types_1.default.node.isRequired,
    classes: prop_types_1.default.object,
    className: prop_types_1.default.string,
    currentSort: prop_types_1.default.shape({
        field: prop_types_1.default.string,
        order: prop_types_1.default.string,
    }),
    data: prop_types_1.default.object.isRequired,
    expand: prop_types_1.default.node,
    hasBulkActions: prop_types_1.default.bool.isRequired,
    hover: prop_types_1.default.bool,
    ids: prop_types_1.default.arrayOf(prop_types_1.default.any).isRequired,
    isLoading: prop_types_1.default.bool,
    onSelect: prop_types_1.default.func,
    onToggleItem: prop_types_1.default.func,
    resource: prop_types_1.default.string,
    rowClick: prop_types_1.default.oneOfType([prop_types_1.default.string, prop_types_1.default.func]),
    rowStyle: prop_types_1.default.func,
    selectedIds: prop_types_1.default.arrayOf(prop_types_1.default.any).isRequired,
    setSort: prop_types_1.default.func,
    total: prop_types_1.default.number,
    version: prop_types_1.default.number,
};
Datagrid.defaultProps = {
    data: {},
    hasBulkActions: false,
    ids: [],
    selectedIds: [],
    body: react_1.default.createElement(DatagridBody_1.default, null),
};
exports.default = styles_1.withStyles(styles)(Datagrid);
