"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var Toolbar_1 = __importDefault(require("@material-ui/core/Toolbar"));
var styles_1 = require("@material-ui/core/styles");
var styles = styles_1.createStyles({
    toolbar: {
        justifyContent: 'space-between',
    },
});
var ListToolbar = function (_a) {
    var classes = _a.classes, filters = _a.filters, actions = _a.actions, bulkActions = _a.bulkActions, exporter = _a.exporter, rest = __rest(_a, ["classes", "filters", "actions", "bulkActions", "exporter"]);
    return (react_1.default.createElement(Toolbar_1.default, { className: classes.toolbar },
        filters &&
            react_1.default.cloneElement(filters, __assign({}, rest, { context: 'form' })),
        react_1.default.createElement("span", null),
        actions &&
            react_1.default.cloneElement(actions, __assign({}, rest, { className: classes.actions, bulkActions: bulkActions,
                exporter: exporter,
                filters: filters }))));
};
ListToolbar.propTypes = {
    classes: prop_types_1.default.object,
    filters: prop_types_1.default.element,
    actions: prop_types_1.default.element,
    bulkActions: prop_types_1.default.oneOfType([prop_types_1.default.element, prop_types_1.default.bool]),
    exporter: prop_types_1.default.oneOfType([prop_types_1.default.func, prop_types_1.default.bool]),
};
ListToolbar.defaultProps = {
    classes: {},
};
exports.default = styles_1.withStyles(styles)(ListToolbar);
