"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginFormClasses = exports.LoginForm = void 0;
var React = __importStar(require("react"));
var styles_1 = require("@mui/material/styles");
var material_1 = require("@mui/material");
var ra_core_1 = require("ra-core");
var input_1 = require("../input");
var LoginForm = function (props) {
    var redirectTo = props.redirectTo, className = props.className;
    var _a = (0, ra_core_1.useSafeSetState)(false), loading = _a[0], setLoading = _a[1];
    var login = (0, ra_core_1.useLogin)();
    var translate = (0, ra_core_1.useTranslate)();
    var notify = (0, ra_core_1.useNotify)();
    var submit = function (values) {
        setLoading(true);
        login(values, redirectTo)
            .then(function () {
            setLoading(false);
        })
            .catch(function (error) {
            setLoading(false);
            notify(typeof error === 'string'
                ? error
                : typeof error === 'undefined' || !error.message
                    ? 'ra.auth.sign_in_error'
                    : error.message, {
                type: 'error',
                messageArgs: {
                    _: typeof error === 'string'
                        ? error
                        : error && error.message
                            ? error.message
                            : undefined,
                },
            });
        });
    };
    return (React.createElement(StyledForm, { onSubmit: submit, mode: "onChange", noValidate: true, className: className },
        React.createElement(material_1.CardContent, { className: exports.LoginFormClasses.content },
            React.createElement(input_1.TextInput, { autoFocus: true, source: "username", label: translate('ra.auth.username'), autoComplete: "username", validate: (0, ra_core_1.required)() }),
            React.createElement(input_1.TextInput, { source: "password", label: translate('ra.auth.password'), type: "password", autoComplete: "current-password", validate: (0, ra_core_1.required)() }),
            React.createElement(material_1.Button, { variant: "contained", type: "submit", color: "primary", disabled: loading, fullWidth: true, className: exports.LoginFormClasses.button }, loading ? (React.createElement(material_1.CircularProgress, { className: exports.LoginFormClasses.icon, size: 19, thickness: 3 })) : (translate('ra.auth.sign_in'))))));
};
exports.LoginForm = LoginForm;
var PREFIX = 'RaLoginForm';
exports.LoginFormClasses = {
    content: "".concat(PREFIX, "-content"),
    button: "".concat(PREFIX, "-button"),
    icon: "".concat(PREFIX, "-icon"),
};
var StyledForm = (0, styles_1.styled)(ra_core_1.Form, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["& .".concat(exports.LoginFormClasses.content)] = {
            width: 300,
        },
        _b["& .".concat(exports.LoginFormClasses.button)] = {
            marginTop: theme.spacing(2),
        },
        _b["& .".concat(exports.LoginFormClasses.icon)] = {
            margin: theme.spacing(0.3),
        },
        _b);
});
//# sourceMappingURL=LoginForm.js.map