import * as React from 'react';
import { Exporter } from 'ra-core';
import { ButtonProps } from './Button';
/**
 * Export the selected rows
 *
 * To be used inside the <Datagrid bulkActionButtons> prop.
 *
 * @example // basic usage
 * import { BulkDeleteButton, BulkExportButton, List, Datagrid } from 'react-admin';
 *
 * const PostBulkActionButtons = () => (
 *     <>
 *         <BulkExportButton />
 *         <BulkDeleteButton />
 *     </>
 * );
 *
 * export const PostList = () => (
 *     <List>
 *        <Datagrid bulkActionButtons={<PostBulkActionButtons />}>
 *          ...
 *       </Datagrid>
 *     </List>
 * );
 */
export declare const BulkExportButton: (props: BulkExportButtonProps) => React.JSX.Element;
interface Props {
    exporter?: Exporter;
    icon?: JSX.Element;
    label?: string;
    onClick?: (e: Event) => void;
    resource?: string;
    meta?: any;
}
export type BulkExportButtonProps = Props & ButtonProps;
export {};
//# sourceMappingURL=BulkExportButton.d.ts.map