"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrevNextButtonClasses = exports.PrevNextButtons = void 0;
var React = __importStar(require("react"));
var ra_core_1 = require("ra-core");
var NavigateBefore_1 = __importDefault(require("@mui/icons-material/NavigateBefore"));
var NavigateNext_1 = __importDefault(require("@mui/icons-material/NavigateNext"));
var Error_1 = __importDefault(require("@mui/icons-material/Error"));
var react_router_dom_1 = require("react-router-dom");
var material_1 = require("@mui/material");
var clsx_1 = __importDefault(require("clsx"));
var LinearProgress_1 = require("../layout/LinearProgress");
/**
 * A component used to render the previous and next buttons in a Show or Edit view.
 *
 * The `<PrevNextButtons>` component renders navigation buttons linking to
 * the next and previous records of the current resource, the current index
 * and the total number of records.
 *
 * It uses usePrevNextController to fetch the list of records.
 *
 * `<PrevNextButtons>` can be used anywhere a record context is provided
 * (often inside a `<Show>` or `<Edit>` component).
 *
 * @example <caption>navigate to edit view by default</caption>
 * <ShowButton />
 *
 * @example <caption>navigate to show view</caption>
 * <PrevNextButtons linkType="show" />
 *
 * @example <caption>custom storeKey</caption>
 * <PrevNextButtons storeKey="listStoreKey" />
 *
 * @example <caption>limit the number of records to fetch</caption>
 * <PrevNextButtons limit={500} />
 *
 * @example <caption>customize filters and sort order</caption>
 * <PrevNextButtons
 *     linkType="show"
 *     sort={{
 *         field: 'first_name',
 *         order: 'DESC',
 *     }}
 *     filter={{ q: 'East a' }}
 * />
 *
 * @example <caption>customize style</caption>
 * <PrevNextButtons
 *     sx={{
 *         color: 'blue',
 *         '& .RaPrevNextButton-list': {
 *             marginBottom: '20px',
 *             color: 'red',
 *         },
 *     }}
 * />
 *
 * @example <caption>in an edit view</caption>
 * import * as React from "react";
 * import { Edit, PrevNextButtons, ShowButton, SimpleForm, TopToolbar } from 'react-admin';
 *
 * const MyTopToolbar = ({ children }) => (
 *     <TopToolbar>
 *         {children}
 *     </TopToolbar>
 * );
 *
 * export const PostEdit = () => (
 *      <Edit
 *          actions={
 *              <MyTopToolbar>
 *                  <PrevNextButtons
 *                      sort={{
 *                          field: 'first_name',
 *                          order: 'DESC',
 *                      }}
 *                      filter={{ q: 'East a' }}
 *                  />
 *                  <ShowButton />
 *              </MyTopToolbar>
 *          }
 *      >
 *          <SimpleForm>...</SimpleForm>
 *      </Edit>
 * );
 */
var PrevNextButtons = function (props) {
    var sx = props.sx;
    var _a = (0, ra_core_1.usePrevNextController)(props), hasPrev = _a.hasPrev, hasNext = _a.hasNext, prevPath = _a.prevPath, nextPath = _a.nextPath, index = _a.index, total = _a.total, error = _a.error, isPending = _a.isPending;
    var translate = (0, ra_core_1.useTranslate)();
    if (isPending) {
        return (React.createElement(material_1.Box, { minHeight: 34, display: "flex", alignItems: "center" },
            React.createElement(LinearProgress_1.LinearProgress, null)));
    }
    if (error) {
        return (React.createElement(Error_1.default, { color: "error", fontSize: "small", titleAccess: "error", "aria-errormessage": error.message }));
    }
    if (!hasPrev && !hasNext) {
        return React.createElement(material_1.Box, { minHeight: 34 });
    }
    return (React.createElement(Root, { sx: sx, role: "navigation", direction: "row", className: (0, clsx_1.default)(exports.PrevNextButtonClasses.root) },
        hasPrev && prevPath ? (React.createElement(material_1.IconButton, { component: react_router_dom_1.Link, to: prevPath, "aria-label": translate('ra.navigation.previous'), size: "small" },
            React.createElement(NavigateBefore_1.default, null))) : (React.createElement(material_1.IconButton, { "aria-label": translate('ra.navigation.previous'), disabled: true, size: "small" },
            React.createElement(NavigateBefore_1.default, null))),
        typeof index === 'number' && (React.createElement(material_1.Typography, { variant: "body2" },
            index + 1,
            " / ",
            total)),
        hasNext && nextPath ? (React.createElement(material_1.IconButton, { component: react_router_dom_1.Link, to: nextPath, "aria-label": translate('ra.navigation.next'), size: "small" },
            React.createElement(NavigateNext_1.default, null))) : (React.createElement(material_1.IconButton, { "aria-label": translate('ra.navigation.next'), disabled: true, size: "small" },
            React.createElement(NavigateNext_1.default, null)))));
};
exports.PrevNextButtons = PrevNextButtons;
var PREFIX = 'RaPrevNextButton';
exports.PrevNextButtonClasses = {
    root: "".concat(PREFIX, "-root"),
};
var Root = (0, material_1.styled)(material_1.Stack, {
    name: PREFIX,
    overridesResolver: function (_props, styles) { return styles.root; },
})({
    display: 'inline-flex',
    alignItems: 'center',
    gap: '0.5em',
});
//# sourceMappingURL=PrevNextButtons.js.map