"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShowGuesser = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var ra_core_1 = require("ra-core");
var inflection_1 = require("inflection");
var ShowView_1 = require("./ShowView");
var showFieldTypes_1 = require("./showFieldTypes");
var ShowGuesser = function (_a) {
    var id = _a.id, queryOptions = _a.queryOptions, resource = _a.resource, rest = __rest(_a, ["id", "queryOptions", "resource"]);
    return (React.createElement(ra_core_1.ShowBase, { id: id, resource: resource, queryOptions: queryOptions },
        React.createElement(ShowViewGuesser, __assign({}, rest))));
};
exports.ShowGuesser = ShowGuesser;
var ShowViewGuesser = function (props) {
    var resource = (0, ra_core_1.useResourceContext)(props);
    if (!resource) {
        throw new Error("<ShowGuesser> was called outside of a ResourceContext and without a resource prop. You must set the resource prop.");
    }
    var record = (0, ra_core_1.useShowContext)().record;
    var _a = (0, react_1.useState)(null), child = _a[0], setChild = _a[1];
    var _b = props.enableLog, enableLog = _b === void 0 ? process.env.NODE_ENV === 'development' : _b, rest = __rest(props, ["enableLog"]);
    (0, react_1.useEffect)(function () {
        setChild(null);
    }, [resource]);
    (0, react_1.useEffect)(function () {
        if (record && !child) {
            var inferredElements = (0, ra_core_1.getElementsFromRecords)([record], showFieldTypes_1.showFieldTypes);
            var inferredChild = new ra_core_1.InferredElement(showFieldTypes_1.showFieldTypes.show, null, inferredElements);
            setChild(inferredChild.getElement());
            if (!enableLog)
                return;
            var representation = inferredChild.getRepresentation();
            var components = ['Show']
                .concat(Array.from(new Set(Array.from(representation.matchAll(/<([^/\s>]+)/g))
                .map(function (match) { return match[1]; })
                .filter(function (component) { return component !== 'span'; }))))
                .sort();
            // eslint-disable-next-line no-console
            console.log("Guessed Show:\n\nimport { ".concat(components.join(', '), " } from 'react-admin';\n\nexport const ").concat((0, inflection_1.capitalize)((0, inflection_1.singularize)(resource)), "Show = () => (\n    <Show>\n").concat(inferredChild.getRepresentation(), "\n    </Show>\n);"));
        }
    }, [record, child, resource, enableLog]);
    return React.createElement(ShowView_1.ShowView, __assign({}, rest), child);
};
//# sourceMappingURL=ShowGuesser.js.map