"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleShowLayoutClasses = exports.SimpleShowLayout = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var styles_1 = require("@mui/material/styles");
var material_1 = require("@mui/material");
var clsx_1 = __importDefault(require("clsx"));
var ra_core_1 = require("ra-core");
var Labeled_1 = require("../Labeled");
/**
 * Layout for a Show view showing fields in one column.
 *
 * It pulls the record from the RecordContext. It renders the record fields in
 * a single-column layout (via Material UI's `<Stack>` component).
 * `<SimpleShowLayout>` delegates the actual rendering of fields to its children.
 * It wraps each field inside a `<Labeled>` component to add a label.
 *
 * @example
 * // in src/posts.js
 * import * as React from "react";
 * import { Show, SimpleShowLayout, TextField } from 'react-admin';
 *
 * export const PostShow = () => (
 *     <Show>
 *         <SimpleShowLayout>
 *             <TextField source="title" />
 *         </SimpleShowLayout>
 *     </Show>
 * );
 *
 * // in src/App.js
 * import * as React from "react";
 * import { Admin, Resource } from 'react-admin';
 *
 * import { PostShow } from './posts';
 *
 * const App = () => (
 *     <Admin dataProvider={...}>
 *         <Resource name="posts" show={PostShow} />
 *     </Admin>
 * );
 *
 * @param {SimpleShowLayoutProps} props
 * @param {string} props.className A className to apply to the page content.
 * @param {ElementType} props.component The component to use as root component (div by default).
 * @param {ReactNode} props.divider An optional divider between each field, passed to `<Stack>`.
 * @param {number} props.spacing The spacing to use between each field, passed to `<Stack>`. Defaults to 1.
 * @param {Object} props.sx Custom style object.
 */
var SimpleShowLayout = function (props) {
    var className = props.className, children = props.children, _a = props.spacing, spacing = _a === void 0 ? 1 : _a, sx = props.sx, rest = __rest(props, ["className", "children", "spacing", "sx"]);
    var record = (0, ra_core_1.useRecordContext)(props);
    if (!record) {
        return null;
    }
    return (React.createElement(ra_core_1.OptionalRecordContextProvider, { value: props.record },
        React.createElement(Root, { className: className, sx: sx },
            React.createElement(material_1.Stack, __assign({ spacing: spacing }, sanitizeRestProps(rest), { className: exports.SimpleShowLayoutClasses.stack }), react_1.Children.map(children, function (field) {
                return field && (0, react_1.isValidElement)(field) ? (React.createElement(Labeled_1.Labeled, { key: field.props.source, className: (0, clsx_1.default)('ra-field', field.props.source &&
                        "ra-field-".concat(field.props.source), exports.SimpleShowLayoutClasses.row, field.props.className) }, field)) : null;
            })))));
};
exports.SimpleShowLayout = SimpleShowLayout;
var PREFIX = 'RaSimpleShowLayout';
exports.SimpleShowLayoutClasses = {
    stack: "".concat(PREFIX, "-stack"),
    row: "".concat(PREFIX, "-row"),
};
var Root = (0, styles_1.styled)('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            flex: 1,
            padding: "".concat(theme.spacing(1), " ").concat(theme.spacing(2))
        },
        _b["& .".concat(exports.SimpleShowLayoutClasses.stack)] = {},
        _b["& .".concat(exports.SimpleShowLayoutClasses.row)] = {
            display: 'inline',
        },
        _b);
});
var sanitizeRestProps = function (_a) {
    var record = _a.record, resource = _a.resource, initialValues = _a.initialValues, translate = _a.translate, rest = __rest(_a, ["record", "resource", "initialValues", "translate"]);
    return rest;
};
//# sourceMappingURL=SimpleShowLayout.js.map