"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TabbedShowLayoutClasses = exports.TabbedShowLayout = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var styles_1 = require("@mui/material/styles");
var material_1 = require("@mui/material");
var react_router_dom_1 = require("react-router-dom");
var ra_core_1 = require("ra-core");
var TabbedShowLayoutTabs_1 = require("./TabbedShowLayoutTabs");
var Tab_1 = require("./Tab");
/**
 * Layout for a Show view showing fields grouped in tabs and laid out in a single column.
 *
 * It pulls the record from the RecordContext. It renders a set of `<Tabs>`,
 * each of which contains a list of record fields in a single-column layout
 * (via Material UI's `<Stack>` component).
 * `<TabbedShowLayout>` delegates the actual rendering of fields to its children,
 * which should be `<TabbedShowLayout.Tab>` components.
 * `<TabbedShowLayout.Tab>` wraps each field inside a `<Labeled>` component to add a label.
 *
 * @example
 * // in src/posts.js
 * import * as React from "react";
 * import { Show, TabbedShowLayout, TextField } from 'react-admin';
 *
 * export const PostShow = () => (
 *     <Show>
 *         <TabbedShowLayout>
 *             <TabbedShowLayout.Tab label="Content">
 *                 <TextField source="title" />
 *                 <TextField source="subtitle" />
 *            </TabbedShowLayout.Tab>
 *             <TabbedShowLayout.Tab label="Metadata">
 *                 <TextField source="category" />
 *            </TabbedShowLayout.Tab>
 *         </TabbedShowLayout>
 *     </Show>
 * );
 *
 * // in src/App.js
 * import * as React from "react";
 * import { Admin, Resource } from 'react-admin';
 *
 * import { PostShow } from './posts';
 *
 * const App = () => (
 *     <Admin dataProvider={...}>
 *         <Resource name="posts" show={PostShow} />
 *     </Admin>
 * );
 *
 * @param {TabbedShowLayoutProps} props
 * @param {string} props.className A className to apply to the page content.
 * @param {ElementType} props.component The component to use as root component (div by default).
 * @param {ReactNode} props.divider An optional divider between each field, passed to `<Stack>`.
 * @param {number} props.spacing The spacing to use between each field, passed to `<Stack>`. Defaults to 1.
 * @param {Object} props.sx Custom style object.
 * @param {boolean} props.syncWithLocation Whether to update the URL when the tab changes. Defaults to true.
 * @param {ElementType} props.tabs A custom component for rendering tabs.
 */
var TabbedShowLayout = function (props) {
    var children = props.children, className = props.className, spacing = props.spacing, divider = props.divider, _a = props.syncWithLocation, syncWithLocation = _a === void 0 ? true : _a, _b = props.tabs, tabs = _b === void 0 ? DefaultTabs : _b, value = props.value, rest = __rest(props, ["children", "className", "spacing", "divider", "syncWithLocation", "tabs", "value"]);
    var record = (0, ra_core_1.useRecordContext)(props);
    var nonNullChildren = react_1.Children.toArray(children).filter(function (child) { return child !== null; });
    var _c = (0, react_1.useState)(0), tabValue = _c[0], setTabValue = _c[1];
    var handleTabChange = function (event, value) {
        if (!syncWithLocation) {
            setTabValue(value);
        }
    };
    if (!record) {
        return null;
    }
    var renderTabHeaders = function () {
        return (0, react_1.cloneElement)(tabs, {
            onChange: handleTabChange,
            syncWithLocation: syncWithLocation,
            value: tabValue,
        }, nonNullChildren);
    };
    return (React.createElement(ra_core_1.OptionalRecordContextProvider, { value: props.record },
        React.createElement(Root, __assign({ className: className }, sanitizeRestProps(rest)), syncWithLocation ? (React.createElement(react_router_dom_1.Routes, null,
            React.createElement(react_router_dom_1.Route, { path: "/*", element: React.createElement(React.Fragment, null,
                    renderTabHeaders(),
                    React.createElement(material_1.Divider, null),
                    React.createElement("div", { className: exports.TabbedShowLayoutClasses.content },
                        React.createElement(react_router_dom_1.Outlet, null))) }, react_1.Children.map(nonNullChildren, function (tab, index) {
                return (0, react_1.isValidElement)(tab) ? (React.createElement(react_router_dom_1.Route, { path: (0, TabbedShowLayoutTabs_1.getShowLayoutTabFullPath)(tab, index), element: (0, react_1.cloneElement)(tab, {
                        context: 'content',
                        spacing: spacing,
                        divider: divider,
                    }) })) : null;
            })))) : (React.createElement(React.Fragment, null,
            renderTabHeaders(),
            React.createElement(material_1.Divider, null),
            React.createElement("div", { className: exports.TabbedShowLayoutClasses.content }, react_1.Children.map(nonNullChildren, function (tab, index) {
                if (!(0, react_1.isValidElement)(tab) ||
                    tabValue !== index) {
                    return null;
                }
                return (0, react_1.cloneElement)(tab, {
                    context: 'content',
                    spacing: spacing,
                    divider: divider,
                });
            })))))));
};
exports.TabbedShowLayout = TabbedShowLayout;
exports.TabbedShowLayout.Tab = Tab_1.Tab;
var DefaultTabs = React.createElement(TabbedShowLayoutTabs_1.TabbedShowLayoutTabs, null);
var PREFIX = 'RaTabbedShowLayout';
exports.TabbedShowLayoutClasses = {
    content: "".concat(PREFIX, "-content"),
};
var Root = (0, styles_1.styled)('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            flex: 1
        },
        _b["& .".concat(exports.TabbedShowLayoutClasses.content)] = {
            padding: "".concat(theme.spacing(1), " ").concat(theme.spacing(2)),
        },
        _b);
});
var sanitizeRestProps = function (_a) {
    var record = _a.record, resource = _a.resource, initialValues = _a.initialValues, staticContext = _a.staticContext, translate = _a.translate, tabs = _a.tabs, rest = __rest(_a, ["record", "resource", "initialValues", "staticContext", "translate", "tabs"]);
    return rest;
};
//# sourceMappingURL=TabbedShowLayout.js.map