"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArrayField = void 0;
var React = __importStar(require("react"));
var ra_core_1 = require("ra-core");
var genericMemo_1 = require("./genericMemo");
/**
 * Renders an embedded array of objects.
 *
 * ArrayField creates a ListContext with the field value, and renders its children components -
 * usually iterator components like Datagrid, SingleFieldList, or SimpleList.
 *
 * @example // Display all the tags of the current post as `<Chip>` components
 * // const post = {
 * //   id: 123
 * //   tags: [
 * //     { name: 'foo' },
 * //     { name: 'bar' }
 * //   ]
 * // };
 * const PostShow = () => (
 *    <Show>
 *       <SimpleShowLayout>
 *           <ArrayField source="tags">
 *               <SingleFieldList>
 *                   <ChipField source="name" />
 *               </SingleFieldList>
 *           </ArrayField>
 *      </SimpleShowLayout>
 *   </Show>
 * );
 *
 * @example // Display all the backlinks of the current post as a `<Datagrid>`
 * // const post = {
 * //   id: 123
 * //   backlinks: [
 * //       {
 * //           uuid: '34fdf393-f449-4b04-a423-38ad02ae159e',
 * //           date: '2012-08-10T00:00:00.000Z',
 * //           url: 'http://example.com/foo/bar.html',
 * //       },
 * //       {
 * //           uuid: 'd907743a-253d-4ec1-8329-404d4c5e6cf1',
 * //           date: '2012-08-14T00:00:00.000Z',
 * //           url: 'https://blog.johndoe.com/2012/08/12/foobar.html',
 * //       }
 * //    ]
 * // };
 * <ArrayField source="backlinks">
 *     <Datagrid>
 *         <DateField source="date" />
 *         <UrlField source="url" />
 *     </Datagrid>
 * </ArrayField>
 *
 * @example // If you need to render a collection of strings, it's often simpler to write your own component
 * const TagsField = () => {
 *     const record = useRecordContext();
 *     return (
 *         <ul>
 *             {record.tags.map(item => (
 *                 <li key={item.name}>{item.name}</li>
 *             ))}
 *         </ul>
 *     );
 * };
 *
 * @see useListContext
 */
var ArrayFieldImpl = function (props) {
    var children = props.children, resource = props.resource, perPage = props.perPage, sort = props.sort, filter = props.filter;
    var data = (0, ra_core_1.useFieldValue)(props) || emptyArray;
    var listContext = (0, ra_core_1.useList)({ data: data, resource: resource, perPage: perPage, sort: sort, filter: filter });
    return (React.createElement(ra_core_1.ListContextProvider, { value: listContext }, children));
};
ArrayFieldImpl.displayName = 'ArrayFieldImpl';
exports.ArrayField = (0, genericMemo_1.genericMemo)(ArrayFieldImpl);
var emptyArray = [];
//# sourceMappingURL=ArrayField.js.map