import * as React from 'react';
import { ReactNode } from 'react';
import { TypographyProps } from '@mui/material/Typography';
import { FieldProps } from './types';
/**
 * Field using a render function
 *
 * @example
 * <FunctionField
 *     source="last_name" // used for sorting
 *     label="Name"
 *     render={record => `${record.first_name} ${record.last_name}`}
 * />
 */
export declare const FunctionField: <RecordType extends Record<string, any> = any>(props: FunctionFieldProps<RecordType>) => React.JSX.Element | null;
export interface FunctionFieldProps<RecordType extends Record<string, any> = any> extends Omit<FieldProps<RecordType>, 'source'>, Omit<TypographyProps, 'textAlign'> {
    source?: string;
    render: (record: RecordType, source?: string) => ReactNode;
}
//# sourceMappingURL=FunctionField.d.ts.map