"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlField = void 0;
var React = __importStar(require("react"));
var sanitizeFieldRestProps_1 = require("./sanitizeFieldRestProps");
var material_1 = require("@mui/material");
var ra_core_1 = require("ra-core");
var genericMemo_1 = require("./genericMemo");
var UrlFieldImpl = function (props) {
    var className = props.className, emptyText = props.emptyText, content = props.content, rest = __rest(props, ["className", "emptyText", "content"]);
    var value = (0, ra_core_1.useFieldValue)(props);
    var translate = (0, ra_core_1.useTranslate)();
    if (value == null) {
        return (React.createElement(material_1.Typography, __assign({ component: "span", variant: "body2", className: className }, (0, sanitizeFieldRestProps_1.sanitizeFieldRestProps)(rest)), emptyText && translate(emptyText, { _: emptyText })));
    }
    return (React.createElement(material_1.Link, __assign({ className: className, href: value, onClick: stopPropagation, variant: "body2" }, (0, sanitizeFieldRestProps_1.sanitizeFieldRestProps)(rest)), content !== null && content !== void 0 ? content : value));
};
UrlFieldImpl.displayName = 'UrlFieldImpl';
exports.UrlField = (0, genericMemo_1.genericMemo)(UrlFieldImpl);
// useful to prevent click bubbling in a Datagrid with rowClick
var stopPropagation = function (e) { return e.stopPropagation(); };
//# sourceMappingURL=UrlField.js.map