"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleFormConfigurable = void 0;
var React = __importStar(require("react"));
var ra_core_1 = require("ra-core");
var preferences_1 = require("../preferences");
var SimpleForm_1 = require("./SimpleForm");
var SimpleFormEditor_1 = require("./SimpleFormEditor");
var SimpleFormConfigurable = function (_a) {
    var preferenceKey = _a.preferenceKey, omit = _a.omit, props = __rest(_a, ["preferenceKey", "omit"]);
    var translate = (0, ra_core_1.useTranslate)();
    var resource = (0, ra_core_1.useResourceContext)(props);
    var finalPreferenceKey = preferenceKey || "".concat(resource, ".simpleForm");
    var _b = (0, ra_core_1.useStore)("preferences.".concat(finalPreferenceKey, ".availableInputs"), EMPTY_ARRAY), availableInputs = _b[0], setAvailableInputs = _b[1];
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    var _c = (0, ra_core_1.useStore)("preferences.".concat(finalPreferenceKey, ".omit"), omit), _ = _c[0], setOmit = _c[1];
    React.useEffect(function () {
        var _a, _b;
        // first render, or the preference have been cleared
        var inputs = (_b = (_a = React.Children.map(props.children, function (child, index) {
            return React.isValidElement(child)
                ? {
                    index: String(index),
                    source: child.props.source,
                    label: child.props.source || child.props.label
                        ? child.props.label
                        : translate('ra.configurable.SimpleForm.unlabeled', {
                            input: index,
                            _: "Unlabeled input #%{input}",
                        }),
                }
                : null;
        })) === null || _a === void 0 ? void 0 : _a.filter(function (column) { return column != null; })) !== null && _b !== void 0 ? _b : EMPTY_ARRAY;
        if (inputs.length !== availableInputs.length) {
            setAvailableInputs(inputs);
            setOmit(omit || EMPTY_ARRAY);
        }
    }, [availableInputs]); // eslint-disable-line react-hooks/exhaustive-deps
    return (React.createElement(preferences_1.Configurable, { editor: React.createElement(SimpleFormEditor_1.SimpleFormEditor, null), preferenceKey: finalPreferenceKey, sx: {
            display: 'block',
            '&.RaConfigurable-editMode': {
                margin: '2px',
            },
        } },
        React.createElement(SimpleFormWithPreferences, __assign({}, props))));
};
exports.SimpleFormConfigurable = SimpleFormConfigurable;
var EMPTY_ARRAY = [];
/**
 * This SimpleForm filters its children depending on preferences
 */
var SimpleFormWithPreferences = function (_a) {
    var children = _a.children, props = __rest(_a, ["children"]);
    var availableInputs = (0, ra_core_1.usePreference)('availableInputs', [])[0];
    var omit = (0, ra_core_1.usePreference)('omit', [])[0];
    var inputs = (0, ra_core_1.usePreference)('inputs', availableInputs
        .filter(function (input) { return !(omit === null || omit === void 0 ? void 0 : omit.includes(input.source)); })
        .map(function (input) { return input.index; }))[0];
    var childrenArray = React.Children.toArray(children);
    return (React.createElement(SimpleForm_1.SimpleForm, __assign({}, props), inputs === undefined
        ? children
        : inputs.map(function (index) { return childrenArray[index]; })));
};
//# sourceMappingURL=SimpleFormConfigurable.js.map