"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findTabsWithErrors = exports.TabbedForm = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var ra_core_1 = require("ra-core");
var get_1 = __importDefault(require("lodash/get"));
var TabbedFormView_1 = require("./TabbedFormView");
var useFormRootPath_1 = require("./useFormRootPath");
var FormTab_1 = require("./FormTab");
/**
 * Form layout where inputs are divided by tab, one input per line.
 *
 * Pass <TabbedForm.Tab> components as children.
 *
 * @example
 *
 * import * as React from "react";
 * import {
 *     Edit,
 *     TabbedForm,
 *     Datagrid,
 *     TextField,
 *     DateField,
 *     TextInput,
 *     ReferenceManyField,
 *     NumberInput,
 *     DateInput,
 *     BooleanInput,
 *     EditButton
 * } from 'react-admin';
 *
 * export const PostEdit = () => (
 *     <Edit>
 *         <TabbedForm>
 *             <TabbedForm.Tab label="summary">
 *                 <TextInput disabled label="Id" source="id" />
 *                 <TextInput source="title" validate={required()} />
 *                 <TextInput multiline source="teaser" validate={required()} />
 *             </TabbedForm.Tab>
 *             <TabbedForm.Tab label="body">
 *                 <RichTextInput source="body" validate={required()} label={false} />
 *             </TabbedForm.Tab>
 *             <TabbedForm.Tab label="Miscellaneous">
 *                 <TextInput label="Password (if protected post)" source="password" type="password" />
 *                 <DateInput label="Publication date" source="published_at" />
 *                 <NumberInput source="average_note" validate={[ number(), minValue(0) ]} />
 *                 <BooleanInput label="Allow comments?" source="commentable" defaultValue />
 *                 <TextInput disabled label="Nb views" source="views" />
 *             </TabbedForm.Tab>
 *             <TabbedForm.Tab label="comments">
 *                 <ReferenceManyField reference="comments" target="post_id" label={false}>
 *                     <Datagrid>
 *                         <TextField source="body" />
 *                         <DateField source="created_at" />
 *                         <EditButton />
 *                     </Datagrid>
 *                 </ReferenceManyField>
 *             </TabbedForm.Tab>
 *         </TabbedForm>
 *     </Edit>
 * );
 *
 * @typedef {Object} Props the props you can use (other props are injected by Create or Edit)
 * @prop {ReactElement[]} FormTab elements
 * @prop {Object} defaultValues
 * @prop {Function} validate
 * @prop {ReactElement} toolbar The element displayed at the bottom of the form, containing the SaveButton
 *
 * @param {Props} props
 */
var TabbedForm = function (props) {
    var formRootPathname = (0, useFormRootPath_1.useFormRootPath)();
    return (React.createElement(ra_core_1.Form, __assign({ formRootPathname: formRootPathname }, props),
        React.createElement(TabbedFormView_1.TabbedFormView, __assign({ formRootPathname: formRootPathname }, sanitizeRestProps(props)))));
};
exports.TabbedForm = TabbedForm;
exports.TabbedForm.Tab = FormTab_1.FormTab;
/* eslint-disable @typescript-eslint/no-unused-vars */
var sanitizeRestProps = function (_a) {
    var criteriaMode = _a.criteriaMode, defaultValues = _a.defaultValues, delayError = _a.delayError, formRootPathname = _a.formRootPathname, mode = _a.mode, noValidate = _a.noValidate, onSubmit = _a.onSubmit, record = _a.record, resetOptions = _a.resetOptions, resolver = _a.resolver, reValidateMode = _a.reValidateMode, sanitizeEmptyValues = _a.sanitizeEmptyValues, shouldFocusError = _a.shouldFocusError, shouldUnregister = _a.shouldUnregister, shouldUseNativeValidation = _a.shouldUseNativeValidation, validate = _a.validate, warnWhenUnsavedChanges = _a.warnWhenUnsavedChanges, rest = __rest(_a, ["criteriaMode", "defaultValues", "delayError", "formRootPathname", "mode", "noValidate", "onSubmit", "record", "resetOptions", "resolver", "reValidateMode", "sanitizeEmptyValues", "shouldFocusError", "shouldUnregister", "shouldUseNativeValidation", "validate", "warnWhenUnsavedChanges"]);
    return rest;
};
var findTabsWithErrors = function (children, errors) {
    console.warn('Deprecated. FormTab now wrap their content inside a FormGroupContextProvider. If you implemented custom forms with tabs, please use the FormGroupContextProvider. See https://marmelab.com/react-admin/EditTutorial.html#grouping-inputs');
    return react_1.Children.toArray(children).reduce(function (acc, child) {
        if (!(0, react_1.isValidElement)(child)) {
            return acc;
        }
        var inputs = react_1.Children.toArray(child.props.children);
        if (inputs.some(function (input) {
            return (0, react_1.isValidElement)(input) && (0, get_1.default)(errors, input.props.source);
        })) {
            return __spreadArray(__spreadArray([], acc, true), [child.props.label], false);
        }
        return acc;
    }, []);
};
exports.findTabsWithErrors = findTabsWithErrors;
//# sourceMappingURL=TabbedForm.js.map