"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TabbedFormClasses = exports.TabbedFormView = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var clsx_1 = __importDefault(require("clsx"));
var react_router_dom_1 = require("react-router-dom");
var material_1 = require("@mui/material");
var styles_1 = require("@mui/material/styles");
var ra_core_1 = require("ra-core");
var Toolbar_1 = require("./Toolbar");
var TabbedFormTabs_1 = require("./TabbedFormTabs");
var TabbedFormView = function (props) {
    var children = props.children, className = props.className, _a = props.component, Component = _a === void 0 ? DefaultComponent : _a, formRootPathname = props.formRootPathname, _b = props.syncWithLocation, syncWithLocation = _b === void 0 ? true : _b, _c = props.tabs, tabs = _c === void 0 ? DefaultTabs : _c, _d = props.toolbar, toolbar = _d === void 0 ? DefaultToolbar : _d, rest = __rest(props, ["children", "className", "component", "formRootPathname", "syncWithLocation", "tabs", "toolbar"]);
    var location = (0, react_router_dom_1.useLocation)();
    var resolvedPath = (0, react_router_dom_1.useResolvedPath)('');
    var resource = (0, ra_core_1.useResourceContext)(props);
    var _e = (0, react_1.useState)(0), tabValue = _e[0], setTabValue = _e[1];
    var handleTabChange = function (event, value) {
        if (!syncWithLocation) {
            setTabValue(value);
        }
    };
    var renderTabHeaders = function () {
        return (0, react_1.cloneElement)(tabs, {
            onChange: handleTabChange,
            syncWithLocation: syncWithLocation,
            url: formRootPathname,
            value: tabValue,
        }, children);
    };
    return (React.createElement(Root, __assign({ className: (0, clsx_1.default)('tabbed-form', className) }, sanitizeRestProps(rest)),
        syncWithLocation ? (React.createElement(react_router_dom_1.Routes, null,
            React.createElement(react_router_dom_1.Route, { path: "/*", element: renderTabHeaders() }))) : (renderTabHeaders()),
        React.createElement(material_1.Divider, null),
        React.createElement(Component, null, react_1.Children.map(children, function (tab, index) {
            if (!tab) {
                return null;
            }
            var tabPath = (0, TabbedFormTabs_1.getTabbedFormTabFullPath)(tab, index);
            var hidden = syncWithLocation
                ? !(0, react_router_dom_1.matchPath)("".concat(resolvedPath.pathname, "/").concat(tabPath), 
                // The current location might have encoded segments (e.g. the record id) but resolvedPath.pathname doesn't
                // and the match would fail.
                getDecodedPathname(location.pathname))
                : tabValue !== index;
            return (0, react_1.isValidElement)(tab)
                ? React.cloneElement(tab, {
                    intent: 'content',
                    resource: resource,
                    hidden: hidden,
                    value: syncWithLocation ? tabPath : index,
                })
                : null;
        })),
        toolbar !== false ? toolbar : null));
};
exports.TabbedFormView = TabbedFormView;
/**
 * Returns the pathname with each segment decoded
 */
var getDecodedPathname = function (pathname) {
    return pathname.split('/').map(decodeURIComponent).join('/');
};
var DefaultTabs = React.createElement(TabbedFormTabs_1.TabbedFormTabs, null);
var DefaultComponent = function (_a) {
    var children = _a.children;
    return (React.createElement(material_1.CardContent, null, children));
};
var DefaultToolbar = React.createElement(Toolbar_1.Toolbar, null);
var PREFIX = 'RaTabbedForm';
exports.TabbedFormClasses = {
    errorTabButton: "".concat(PREFIX, "-errorTabButton"),
};
var Root = (0, styles_1.styled)('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["& .MuiTab-root.".concat(exports.TabbedFormClasses.errorTabButton)] = {
            color: theme.palette.error.main,
        },
        _b);
});
var sanitizeRestProps = function (_a) {
    var record = _a.record, resource = _a.resource, rest = __rest(_a, ["record", "resource"]);
    return rest;
};
//# sourceMappingURL=TabbedFormView.js.map