"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useArrayInput = void 0;
var react_1 = require("react");
var ArrayInputContext_1 = require("./ArrayInputContext");
/**
 * A hook to access an array input methods as provided by react-hook-form.
 * Useful to create custom array input iterators.
 * @see {ArrayInput}
 * @see https://react-hook-form.com/docs/usefieldarray
 */
var useArrayInput = function (props) {
    var context = (0, react_1.useContext)(ArrayInputContext_1.ArrayInputContext);
    var memo = (0, react_1.useMemo)(function () {
        return ({
            append: props === null || props === void 0 ? void 0 : props.append,
            fields: props === null || props === void 0 ? void 0 : props.fields,
            insert: props === null || props === void 0 ? void 0 : props.insert,
            move: props === null || props === void 0 ? void 0 : props.move,
            prepend: props === null || props === void 0 ? void 0 : props.prepend,
            remove: props === null || props === void 0 ? void 0 : props.remove,
            replace: props === null || props === void 0 ? void 0 : props.replace,
            swap: props === null || props === void 0 ? void 0 : props.swap,
            update: props === null || props === void 0 ? void 0 : props.update,
        });
    }, [props]);
    if (props === null || props === void 0 ? void 0 : props.fields) {
        return memo;
    }
    if (!context) {
        throw new Error('useArrayInput must be used inside an ArrayInputContextProvider');
    }
    return context;
};
exports.useArrayInput = useArrayInput;
//# sourceMappingURL=useArrayInput.js.map